/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.Validator;
import org.embulk.config.TaskSource;
import org.embulk.util.config.DataSourceImpl;
import org.embulk.util.config.Task;
import org.embulk.util.config.TaskValidationException;
import org.embulk.util.config.Tasks;

final class TaskInvocationHandler
implements InvocationHandler {
    private final Class<? extends Task> taskInterface;
    private final ConcurrentHashMap<String, Object> taskBackingObjects;
    private final ObjectMapper objectMapper;
    private final Validator validator;

    TaskInvocationHandler(Class<? extends Task> taskInterface, Map<String, Object> taskBackingObjects, ObjectMapper objectMapper, Validator validator) {
        this.taskInterface = taskInterface;
        this.taskBackingObjects = new ConcurrentHashMap<String, Object>(taskBackingObjects);
        this.objectMapper = objectMapper;
        this.validator = validator;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        String methodName;
        switch (methodName = method.getName()) {
            case "validate": {
                Set violations;
                Tasks.assertParameters(method, 0);
                if (this.validator != null && !(violations = this.validator.validate(proxy, new Class[0])).isEmpty()) {
                    throw new TaskValidationException(violations);
                }
                return proxy;
            }
            case "dump": 
            case "toTaskSource": {
                Tasks.assertParameters(method, 0);
                return this.invokeToTaskSource();
            }
            case "toObjectNode": {
                Tasks.assertParameters(method, 0);
                return this.invokeToObjectNode();
            }
            case "toString": {
                Tasks.assertParameters(method, 0);
                return this.invokeToString();
            }
            case "hashCode": {
                Tasks.assertParameters(method, 0);
                return this.invokeHashCode();
            }
            case "equals": {
                Tasks.assertParameters(method, 1);
                if (args[0] instanceof Proxy) {
                    InvocationHandler otherHandler = Proxy.getInvocationHandler(args[0]);
                    return this.invokeEquals(otherHandler);
                }
                return false;
            }
        }
        if (methodName.startsWith("get")) {
            return this.invokeGetter(proxy, method);
        }
        if (methodName.startsWith("set")) {
            Tasks.assertParameters(method, 1);
            this.invokeSetter(method, args[0]);
            return this;
        }
        throw new IllegalArgumentException(String.format("Undefined method '%s'", methodName));
    }

    private Object invokeGetter(Object proxy, Method method) {
        String methodName = method.getName();
        Optional<String> fieldName = Tasks.getFieldNameFromGetter(methodName);
        if (!fieldName.isPresent()) {
            throw new IllegalArgumentException("Tried to run a getter " + methodName + ", but the method name is invalid.");
        }
        Tasks.assertParameters(method, 0);
        return this.taskBackingObjects.get(fieldName.get());
    }

    private void invokeSetter(Method method, Object arg) {
        String methodName = method.getName();
        Optional<String> fieldName = Tasks.getFieldNameFromSetter(methodName);
        if (!fieldName.isPresent()) {
            throw new IllegalArgumentException("Tried to run a setter " + methodName + ", but the method name is invalid.");
        }
        if (arg == null) {
            this.taskBackingObjects.remove(fieldName.get());
        } else {
            this.taskBackingObjects.put(fieldName.get(), arg);
        }
    }

    private ObjectNode invokeToObjectNode() {
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        for (Map.Entry<String, Object> pair : this.taskBackingObjects.entrySet()) {
            objectNode.set(pair.getKey(), this.objectMapper.valueToTree(pair.getValue()));
        }
        return objectNode;
    }

    private TaskSource invokeToTaskSource() {
        return new DataSourceImpl(this.invokeToObjectNode(), this.objectMapper);
    }

    private String invokeToString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.taskInterface.getName());
        builder.append(this.taskBackingObjects);
        return builder.toString();
    }

    private int invokeHashCode() {
        return this.taskBackingObjects.hashCode();
    }

    private boolean invokeEquals(Object otherObject) {
        if (!(otherObject instanceof TaskInvocationHandler)) {
            return false;
        }
        TaskInvocationHandler other = (TaskInvocationHandler)otherObject;
        return this.taskBackingObjects.equals(other.taskBackingObjects);
    }
}

