/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config.modules;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

final class LegacyZones {
    private static final Map<String, ZoneId> ALTERNATIVES_CASE_SENSITIVE;
    private static final Map<String, ZoneId> ALTERNATIVES_CASE_INSENSITIVE;
    private static final Map<String, String> SUGGESTIONS_CASE_SENSITIVE;
    private static final Map<String, String> SUGGESTIONS_CASE_INSENSITIVE;
    private static final Object[] CASE_SENSITIVE_SHORT_ZONE_NAMES;
    private static final Object[] CASE_INSENSITIVE_SHORT_ZONE_NAMES;
    private static final Object[] MILITARY_ZONE_NAMES;
    private static final Object[] RUBY_REGION_NAMES;
    private static final Object[] NON_SLASH_BACKWARD_REGION_NAMES;

    private LegacyZones() {
    }

    static Optional<String> getSuggestion(String shortName) {
        if (SUGGESTIONS_CASE_SENSITIVE.containsKey(shortName)) {
            return Optional.of(SUGGESTIONS_CASE_SENSITIVE.get(shortName));
        }
        String shortNameUpperCase = shortName.toUpperCase(Locale.ROOT);
        if ("UTC".equals(shortNameUpperCase)) {
            return Optional.empty();
        }
        return Optional.ofNullable(SUGGESTIONS_CASE_INSENSITIVE.get(shortNameUpperCase));
    }

    static Optional<ZoneId> getAlternative(String shortName) {
        if (ALTERNATIVES_CASE_SENSITIVE.containsKey(shortName)) {
            return Optional.of(ALTERNATIVES_CASE_SENSITIVE.get(shortName));
        }
        String shortNameUpperCase = shortName.toUpperCase(Locale.ROOT);
        if ("UTC".equals(shortNameUpperCase)) {
            return Optional.of(ZoneOffset.UTC);
        }
        return Optional.ofNullable(ALTERNATIVES_CASE_INSENSITIVE.get(shortNameUpperCase));
    }

    private static String zoneToString(ZoneId zone) {
        if (zone.equals(ZoneOffset.UTC)) {
            return "UTC";
        }
        return zone.toString();
    }

    static {
        int i;
        CASE_SENSITIVE_SHORT_ZONE_NAMES = new Object[]{"CDT", ZoneOffset.of("-06:00"), "Use -05:00, -06:00, America/Chicago, America/Mexico_City, or else as needed instead for true Central Daylight Time. Embulk has recognized CDT wrongly as Central Standard Time, and keeps it for compatibility in the legacy mode.", "CET", ZoneId.of("CET"), "Use +01:00, +02:00, Europe/Paris, Europe/Berlin, Africa/Algiers, or else as needed instead for Central European Time.", "EDT", ZoneOffset.of("-05:00"), "Use -05:00, -04:00, America/New_York, America/Toronto, or else as needed instead for true Eastern Daylight Time. Embulk has recognized EDT wrongly as Eastern Standard Time, and keeps it for compatibility in the legacy mode.", "EET", ZoneId.of("EET"), "Use +02:00, +03:00, Europe/Bucharest, Europe/Athens, Africa/Cairo, or else as needed instead for Eastern European Time.", "MDT", ZoneOffset.of("-07:00"), "Use -07:00, -06:00, America/Denver, America/Edmonton, or else as needed instead for true Mountain Daylight Time. Embulk has recognized MDT wrongly as Mountain Standard Time, and keeps it for compatibility in the legacy mode.", "MET", ZoneId.of("MET"), "Use +01:00, +02:00, Europe/Paris, Europe/Berlin, Africa/Algiers, or else as needed instead for Middle (Central) European Time. Or, use +03:30, Asia/Tehran, or else as needed instead for Middle East Time, historical Java standard.", "PDT", ZoneOffset.of("-08:00"), "Use -08:00, -07:00, America/Los_Angeles, America/Vancouver, or else as needed instead for true Pacific Daylight Time. Embulk has recognized PDT wrongly as Pacific Standard Time, and keeps it for compatibility in the legacy mode.", "WET", ZoneId.of("WET"), "Use +00:00, +01:00, Europe/Lisbon, Africa/Casablanca, or else as needed instead for Western European Time."};
        CASE_INSENSITIVE_SHORT_ZONE_NAMES = new Object[]{"ADT", ZoneOffset.of("-03:00"), "Use -03:00, America/Halifax, Canada/Atlantic, or else as needed instead for Atlantic Daylight Time.", "AHST", ZoneOffset.of("-10:00"), "Use -10:00, -09:00, Pacific/Honolulu, America/Adak, or else as needed instead for Alaska-Hawaii Standard Time.", "AKDT", ZoneOffset.of("-08:00"), "Use -08:00, America/Anchorage, or else as needed instead for Alaska Daylight Time.", "AKST", ZoneOffset.of("-09:00"), "Use -09:00, -08:00, America/Anchorage, or else as needed instead for Alaska Standard Time.", "ART", ZoneOffset.of("-03:00"), "Use -03:00, America/Buenos_Aires, America/Cordoba, or else as needed instead for Argentina Time. Or, use +02:00, Africa/Cairo, or else as needed instead for Egypt Time, historical Java standard.", "AST", ZoneOffset.of("-04:00"), "Use -04:00, -03:00, America/Halifax, America/Puerto_Rico, Atlantic/Bermuda, or else as needed instead for Atlantic Standard Time. Or, use -09:00, -08:00, America/Anchorage, or else as needed instead for Alaska Standard Time, historical Java standard.", "AT", ZoneOffset.of("-02:00"), "Use -02:00, Atlantic/Azores, or else as needed instead for obsolete Azores Time.", "BRST", ZoneOffset.of("-02:00"), "Use -02:00, America/Sao_Paulo, or else as needed instead for Brasilia Summer Time.", "BRT", ZoneOffset.of("-03:00"), "Use -03:00, -02:00, America/Sao_Paulo, or else as needed instead for Brasilia Time.", "BST", ZoneOffset.of("+01:00"), "Use +01:00, Europe/London, or else as needed instead for British Summer Time. Or, use +06:00, Asia/Dhaka, or else as needed instead for Bangladesh Standard Time, historical Java standard.", "BT", ZoneOffset.of("+03:00"), "Use +03:00, Asia/Baghdad, or else as needed instead for Baghdad Time.", "CAT", ZoneOffset.of("-10:00"), "Use -10:00 instead for Central Alaska Standard Time. Or, use +02:00, Africa/Harare, Atlantic/Cape_Verde, or else as needed instead for Central Africa Time.", "CCT", ZoneOffset.of("+08:00"), "Use +08:00, Asia/Shanghai, Asia/Taipei, or else as needed instead for China Coastal Time. Or, use +06:30, Indian/Cocos, or else as needed instead for Cocos Islands Time.", "CDT", ZoneOffset.of("-05:00"), "Use -05:00, -06:00, America/Chicago, America/Mexico_City, or else as needed instead for true Central Daylight Time. Embulk has recognized CDT wrongly as Central Standard Time, and keeps it for compatibility in the legacy mode.", "CEST", ZoneOffset.of("+02:00"), "Use +02:00, Europe/Paris, Europe/Berlin, or else as needed instead for Central European Summer Time.", "CET", ZoneOffset.of("+01:00"), "Use +01:00, +02:00, Europe/Paris, Europe/Berlin, Africa/Algiers, or else as needed instead for Central European Time.", "CLST", ZoneOffset.of("-03:00"), "Use -03:00, America/Santiago, or else as needed instead for Chile Summer Time.", "CLT", ZoneOffset.of("-04:00"), "Use -04:00, -03:00, America/Santiago, or else as needed instead for Chile Standard Time.", "CST", ZoneOffset.of("-06:00"), "Use -06:00, -05:00, America/Chicago, America/Mexico_City, America/Guatemala, or else as needed instead for Central Standard Time.", "CST6CDT", ZoneId.of("CST6CDT"), "Use -06:00, -05:00, America/Chicago, America/Mexico_City, America/Guatemala, or else as needed instead for Central Time.", "EADT", ZoneOffset.of("+11:00"), "Use +11:00, Australia/Sydney, or else as needed instead for East Australian Daylight Time.", "EAST", ZoneOffset.of("+10:00"), "Use +10:00, +11:00, Australia/Sydney, Australia/Brisbane, or else as needed instead for East Australian Standard Time. Or, use -06:00, Pacific/Easter, or else as needed instead for Easter Island Standard Time.", "EAT", ZoneOffset.of("+03:00"), "Use +03:00, Africa/Addis_Ababa, Asia/Riyadh, or else as needed instead for Eastern Africa Time.", "EDT", ZoneOffset.of("-04:00"), "Use -05:00, -04:00, America/New_York, America/Toronto, or else as needed instead for true Eastern Daylight Time. Embulk has recognized EDT wrongly as Eastern Standard Time, and keeps it for compatibility in the legacy mode.", "EEST", ZoneOffset.of("+03:00"), "Use +03:00, Europe/Bucharest, Europe/Athens, or else as needed instead for Eastern European Summer Time.", "EET", ZoneOffset.of("+02:00"), "Use +02:00, +03:00, Europe/Bucharest, Europe/Athens, Africa/Cairo, or else as needed instead for Eastern European Time.", "EST", ZoneOffset.of("-05:00"), "Use -05:00, -04:00, America/New_York, America/Toronto, America/Jamaica, or else as needed instead for Eastern Standard Time.", "EST5EDT", ZoneId.of("EST5EDT"), "Use -05:00, -04:00, America/New_York, America/Toronto, America/Jamaica, or else as needed instead for Eastern Time.", "FST", ZoneOffset.of("+02:00"), "Use +02:00, Europe/Paris instead for French Summer Time.", "FWT", ZoneOffset.of("+01:00"), "Use +01:00, Europe/Paris instead for French Winter Time.", "GMT", ZoneOffset.UTC, "Use +00:00, UTC, Europe/London, Atlantic/Reykjavik, or else as needed instead for Greenwich Mean Time.", "GST", ZoneOffset.of("+10:00"), "Use +10:00, Pacific/Guam, Pacific/Saipan, or else as needed instead for Guam Standard Time, also known as Chamorro Time Zone now. Or, use +04:00, Asia/Dubai instead for Gulf Standard Time.", "HADT", ZoneOffset.of("-09:00"), "Use -09:00, America/Adak instead for Hawaii-Aleutian Daylight Time.", "HAST", ZoneOffset.of("-10:00"), "Use -10:00, -09:00, Pacific/Honolulu, America/Adak, or else as needed instead for Hawaii-Aleutian Standard Time.", "HDT", ZoneOffset.of("-09:00"), "Use -09:00, America/Adak instead for Hawaii(-Aleutian) Daylight Time.", "HST", ZoneOffset.of("-10:00"), "Use -10:00, -09:00, Pacific/Honolulu, America/Adak, or else as needed instead for Hawaii(-Aleutian) Standard Time.", "IDLE", ZoneOffset.of("+12:00"), "Use +12:00 instead for Internation Date Line East.", "IDLW", ZoneOffset.of("-12:00"), "Use -12:00 instead for Internation Date Line West.", "IST", ZoneOffset.of("+05:30"), "Use +05:30, Asia/Kolkata, or else as needed instead for India Standard Time.", "JST", ZoneOffset.of("+09:00"), "Use +09:00, Asia/Tokyo, or else as needed instead for Japan Standard Time.", "KST", ZoneOffset.of("+09:00"), "Use +09:00, Asia/Seoul, or else as needed instead for Korea Standard Time.", "MDT", ZoneOffset.of("-06:00"), "Use -07:00, -06:00, America/Denver, America/Edmonton, or else as needed instead for true Mountain Daylight Time. Embulk has recognized MDT wrongly as Mountain Standard Time, and keeps it for compatibility in the legacy mode.", "MEST", ZoneOffset.of("+02:00"), "Use +02:00, Europe/Paris, Europe/Berlin, or else as needed instead for Middle (Central) European Summer Time.", "MESZ", ZoneOffset.of("+02:00"), "Use +02:00, Europe/Berlin, or else as needed instead for Mitteleuropaeische Sommerzeit.", "MET", ZoneOffset.of("+01:00"), "Use +01:00, +02:00, Europe/Paris, Europe/Berlin, Africa/Algiers, or else as needed instead for Middle (Central) European Time. Or, use +03:30, Asia/Tehran, or else as needed instead for Middle East Time, historical Java standard.", "MEWT", ZoneOffset.of("+01:00"), "Use +01:00, Europe/Paris, Europe/Berlin, Africa/Algiers, or else as needed instead for Middle European Winter Time.", "MEZ", ZoneOffset.of("+01:00"), "Use +01:00, +02:00, Europe/Berlin, or else as needed instead for Mitteleuropaeische Zeit.", "MSD", ZoneOffset.of("+04:00"), "Use +04:00, Europe/Moscow, or else as needed instead for Moscow Daylight Time.", "MSK", ZoneOffset.of("+03:00"), "Use +03:00, +04:00, Europe/Moscow, or else as needed instead for Moscow Standard Time.", "MST", ZoneOffset.of("-07:00"), "Use -07:00, -06:00, America/Denver, America/Edmonton, America/Phoenix, or else as needed instead for Mountain Standard Time.", "MST7MDT", ZoneId.of("MST7MDT"), "Use -07:00, -06:00, America/Denver, America/Edmonton, America/Phoenix, or else as needed instead for Mountain Time.", "NDT", ZoneOffset.of("-02:30"), "Use -02:30, America/St_Johns, or else as needed instead for Newfoundland Daylight Time.", "NST", ZoneOffset.of("-03:30"), "Use -03:30, -02:30, America/St_Johns, or else as needed instead for Newfoundland Standard Time.Or, use +12:00, +13:00, Pacific/Auckland, or else instead for New Zealand Standard Time, historical Java standard.", "NT", ZoneOffset.of("-11:00"), "Use -11:00, America/Anchorage, or else as needed instead for obsolete Nome Time.", "NZDT", ZoneOffset.of("+13:00"), "Use +13:00 Pacific/Auckland, or else as needed instead for New Zealand Daylight Time.", "NZST", ZoneOffset.of("+12:00"), "Use +12:00, +13:00, Pacific/Auckland, or else as needed instead for New Zealand Standard Time.", "NZT", ZoneOffset.of("+12:00"), "Use +12:00, +13:00, Pacific/Auckland, or else as needed instead for New Zealand Time.", "PDT", ZoneOffset.of("-07:00"), "Use -08:00, -07:00, America/Los_Angeles, America/Vancouver, or else as needed instead for true Pacific Daylight Time. Embulk has recognized PDT wrongly as Pacific Standard Time, and keeps it for compatibility in the legacy mode.", "PST", ZoneOffset.of("-08:00"), "Use -08:00, -07:00, America/Los_Angeles, America/Vancouver, or else as needed instead for Pacific Standard Time.", "PST8PDT", ZoneId.of("PST8PDT"), "Use -08:00, -07:00, America/Los_Angeles, America/Vancouver, or else as needed instead for Pacific Time.", "SAST", ZoneOffset.of("+02:00"), "Use +02:00, Africa/Johannesburg, or else as needed instead for South Africa Standard Time.", "SGT", ZoneOffset.of("+08:00"), "Use +08:00, Asia/Singapore, or else as needed instead for Singapore Time.", "SST", ZoneOffset.of("+02:00"), "Use +02:00, Europe/Stockholm, or else as needed instead for Swedish Summer Time. Or, use -11:00, Pacific/Pago_Pago, or else as needed instead for Samoa Standard Time.", "SWT", ZoneOffset.of("+01:00"), "Use +01:00, Europe/Stockholm, or else as needed instead for Swedish Winter Time.", "UCT", ZoneOffset.UTC, "Use UTC instead.", "UT", ZoneOffset.UTC, "Use UTC instead.", "WADT", ZoneOffset.of("+08:00"), "Use +08:00, Australia/Perth, or else as needed instead for West Australian Daylight Time.", "WAST", ZoneOffset.of("+07:00"), "Use +07:00, +08:00, Australia/Perth, or else as needed instead for West Australian Standard Time. Or, use +02:00, Africa/Windhoek, or else as needed instead for West Africa Summer Time.", "WAT", ZoneOffset.of("+01:00"), "Use +01:00, +02:00, Africa/Lagos, Africa/Windhoek, or else as needed instead for West Africa Time.", "WEST", ZoneOffset.of("+01:00"), "Use +01:00, Europe/Lisbon, Africa/Casablanca, or else as needed instead for Western European Summer Time.", "WET", ZoneOffset.of("+00:00"), "Use +00:00, +01:00, Europe/Lisbon, Africa/Casablanca, or else as needed instead for Western European Time.", "YDT", ZoneOffset.of("-08:00"), "Use -08:00, America/Whitehorse, America/Yakutat, or else as needed instead for obsolete Yukon Daylight Time.", "YST", ZoneOffset.of("-09:00"), "Use -09:00, -08:00, America/Whitehorse, America/Yakutat, or else as needed instead for obsolete Yukon Daylight Time.", "ZP4", ZoneOffset.of("+04:00"), "Use +04:00, Europe/Samara, or else as needed instead for USSR Zone 3.", "ZP5", ZoneOffset.of("+05:00"), "Use +05:00, Asia/Yekaterinburg, or else as needed instead for USSR Zone 4.", "ZP6", ZoneOffset.of("+06:00"), "Use +06:00, Asia/Omsk, or else as needed instead for USSR Zone 5."};
        MILITARY_ZONE_NAMES = new Object[]{"A", ZoneOffset.ofHours(1), "B", ZoneOffset.ofHours(2), "C", ZoneOffset.ofHours(3), "D", ZoneOffset.ofHours(4), "E", ZoneOffset.ofHours(5), "F", ZoneOffset.ofHours(6), "G", ZoneOffset.ofHours(7), "H", ZoneOffset.ofHours(8), "I", ZoneOffset.ofHours(9), "K", ZoneOffset.ofHours(10), "L", ZoneOffset.ofHours(11), "M", ZoneOffset.ofHours(12), "N", ZoneOffset.ofHours(-1), "O", ZoneOffset.ofHours(-2), "P", ZoneOffset.ofHours(-3), "Q", ZoneOffset.ofHours(-4), "R", ZoneOffset.ofHours(-5), "S", ZoneOffset.ofHours(-6), "T", ZoneOffset.ofHours(-7), "U", ZoneOffset.ofHours(-8), "V", ZoneOffset.ofHours(-9), "W", ZoneOffset.ofHours(-10), "X", ZoneOffset.ofHours(-11), "Y", ZoneOffset.ofHours(-12), "Z", ZoneOffset.UTC};
        RUBY_REGION_NAMES = new Object[]{"afghanistan", ZoneOffset.ofTotalSeconds(16200), "alaskan", ZoneOffset.ofTotalSeconds(-32400), "arab", ZoneOffset.ofTotalSeconds(10800), "arabian", ZoneOffset.ofTotalSeconds(14400), "arabic", ZoneOffset.ofTotalSeconds(10800), "atlantic", ZoneOffset.ofTotalSeconds(-14400), "aus central", ZoneOffset.ofTotalSeconds(34200), "aus eastern", ZoneOffset.ofTotalSeconds(36000), "azores", ZoneOffset.ofTotalSeconds(-3600), "canada central", ZoneOffset.ofTotalSeconds(-21600), "cape verde", ZoneOffset.ofTotalSeconds(-3600), "caucasus", ZoneOffset.ofTotalSeconds(14400), "cen. australia", ZoneOffset.ofTotalSeconds(34200), "central america", ZoneOffset.ofTotalSeconds(-21600), "central asia", ZoneOffset.ofTotalSeconds(21600), "central europe", ZoneOffset.ofTotalSeconds(3600), "central european", ZoneOffset.ofTotalSeconds(3600), "central pacific", ZoneOffset.ofTotalSeconds(39600), "central", ZoneOffset.ofTotalSeconds(-21600), "china", ZoneOffset.ofTotalSeconds(28800), "dateline", ZoneOffset.ofTotalSeconds(-43200), "e. africa", ZoneOffset.ofTotalSeconds(10800), "e. australia", ZoneOffset.ofTotalSeconds(36000), "e. europe", ZoneOffset.ofTotalSeconds(7200), "e. south america", ZoneOffset.ofTotalSeconds(-10800), "eastern", ZoneOffset.ofTotalSeconds(-18000), "egypt", ZoneOffset.ofTotalSeconds(7200), "ekaterinburg", ZoneOffset.ofTotalSeconds(18000), "fiji", ZoneOffset.ofTotalSeconds(43200), "fle", ZoneOffset.ofTotalSeconds(7200), "greenland", ZoneOffset.ofTotalSeconds(-10800), "greenwich", ZoneOffset.ofTotalSeconds(0), "gtb", ZoneOffset.ofTotalSeconds(7200), "hawaiian", ZoneOffset.ofTotalSeconds(-36000), "india", ZoneOffset.ofTotalSeconds(19800), "iran", ZoneOffset.ofTotalSeconds(12600), "jerusalem", ZoneOffset.ofTotalSeconds(7200), "korea", ZoneOffset.ofTotalSeconds(32400), "mexico", ZoneOffset.ofTotalSeconds(-21600), "mid-atlantic", ZoneOffset.ofTotalSeconds(-7200), "mountain", ZoneOffset.ofTotalSeconds(-25200), "myanmar", ZoneOffset.ofTotalSeconds(23400), "n. central asia", ZoneOffset.ofTotalSeconds(21600), "nepal", ZoneOffset.ofTotalSeconds(20700), "new zealand", ZoneOffset.ofTotalSeconds(43200), "newfoundland", ZoneOffset.ofTotalSeconds(-12600), "north asia east", ZoneOffset.ofTotalSeconds(28800), "north asia", ZoneOffset.ofTotalSeconds(25200), "pacific sa", ZoneOffset.ofTotalSeconds(-14400), "pacific", ZoneOffset.ofTotalSeconds(-28800), "romance", ZoneOffset.ofTotalSeconds(3600), "russian", ZoneOffset.ofTotalSeconds(10800), "sa eastern", ZoneOffset.ofTotalSeconds(-10800), "sa pacific", ZoneOffset.ofTotalSeconds(-18000), "sa western", ZoneOffset.ofTotalSeconds(-14400), "samoa", ZoneOffset.ofTotalSeconds(-39600), "se asia", ZoneOffset.ofTotalSeconds(25200), "malay peninsula", ZoneOffset.ofTotalSeconds(28800), "south africa", ZoneOffset.ofTotalSeconds(7200), "sri lanka", ZoneOffset.ofTotalSeconds(21600), "taipei", ZoneOffset.ofTotalSeconds(28800), "tasmania", ZoneOffset.ofTotalSeconds(36000), "tokyo", ZoneOffset.ofTotalSeconds(32400), "tonga", ZoneOffset.ofTotalSeconds(46800), "us eastern", ZoneOffset.ofTotalSeconds(-18000), "us mountain", ZoneOffset.ofTotalSeconds(-25200), "vladivostok", ZoneOffset.ofTotalSeconds(36000), "w. australia", ZoneOffset.ofTotalSeconds(28800), "w. central africa", ZoneOffset.ofTotalSeconds(3600), "w. europe", ZoneOffset.ofTotalSeconds(3600), "west asia", ZoneOffset.ofTotalSeconds(18000), "west pacific", ZoneOffset.ofTotalSeconds(36000), "yakutsk", ZoneOffset.ofTotalSeconds(32400)};
        NON_SLASH_BACKWARD_REGION_NAMES = new Object[]{"Cuba", ZoneId.of("America/Havana"), "Egypt", ZoneId.of("Africa/Cairo"), "Eire", ZoneId.of("Europe/Dublin"), "GB", ZoneId.of("Europe/London"), "GB-Eire", ZoneId.of("Europe/London"), "GMT+0", ZoneId.of("Etc/GMT"), "GMT-0", ZoneId.of("Etc/GMT"), "GMT0", ZoneId.of("Etc/GMT"), "Greenwich", ZoneOffset.UTC, "Hongkong", ZoneId.of("Asia/Hong_Kong"), "Iceland", ZoneId.of("Atlantic/Reykjavik"), "Iran", ZoneId.of("Asia/Tehran"), "Israel", ZoneId.of("Asia/Jerusalem"), "Jamaica", ZoneId.of("America/Jamaica"), "Japan", ZoneId.of("Asia/Tokyo"), "Kwajalein", ZoneId.of("Pacific/Kwajalein"), "Libya", ZoneId.of("Africa/Tripoli"), "NZ", ZoneId.of("Pacific/Auckland"), "NZ-CHAT", ZoneId.of("Pacific/Chatham"), "Navajo", ZoneId.of("America/Denver"), "PRC", ZoneId.of("Asia/Shanghai"), "Poland", ZoneId.of("Europe/Warsaw"), "Portugal", ZoneId.of("Europe/Lisbon"), "ROC", ZoneId.of("Asia/Taipei"), "ROK", ZoneId.of("Asia/Seoul"), "Singapore", ZoneId.of("Asia/Singapore"), "Turkey", ZoneId.of("Europe/Istanbul"), "Universal", ZoneOffset.UTC, "W-SU", ZoneId.of("Europe/Moscow"), "Zulu", ZoneOffset.UTC};
        HashMap<String, ZoneId> alternativesCaseSensitive = new HashMap<String, ZoneId>();
        HashMap<String, String> suggestionsCaseSensitive = new HashMap<String, String>();
        HashMap<String, ZoneId> alternativesCaseInsensitive = new HashMap<String, ZoneId>();
        HashMap<String, String> suggestionsCaseInsensitive = new HashMap<String, String>();
        for (i = 0; i < CASE_SENSITIVE_SHORT_ZONE_NAMES.length; i += 3) {
            alternativesCaseSensitive.put((String)CASE_SENSITIVE_SHORT_ZONE_NAMES[i], (ZoneId)CASE_SENSITIVE_SHORT_ZONE_NAMES[i + 1]);
            suggestionsCaseSensitive.put((String)CASE_SENSITIVE_SHORT_ZONE_NAMES[i], (String)CASE_SENSITIVE_SHORT_ZONE_NAMES[i] + " is deprecated as a short time zone name. " + (String)CASE_SENSITIVE_SHORT_ZONE_NAMES[i + 2]);
        }
        for (i = 0; i < CASE_INSENSITIVE_SHORT_ZONE_NAMES.length; i += 3) {
            alternativesCaseInsensitive.put((String)CASE_INSENSITIVE_SHORT_ZONE_NAMES[i], (ZoneId)CASE_INSENSITIVE_SHORT_ZONE_NAMES[i + 1]);
            suggestionsCaseInsensitive.put((String)CASE_INSENSITIVE_SHORT_ZONE_NAMES[i], (String)CASE_INSENSITIVE_SHORT_ZONE_NAMES[i] + " is deprecated as a short time zone name. " + (String)CASE_INSENSITIVE_SHORT_ZONE_NAMES[i + 2]);
        }
        for (i = 0; i < MILITARY_ZONE_NAMES.length; i += 2) {
            alternativesCaseInsensitive.put((String)MILITARY_ZONE_NAMES[i], (ZoneOffset)MILITARY_ZONE_NAMES[i + 1]);
            suggestionsCaseInsensitive.put((String)MILITARY_ZONE_NAMES[i], (String)MILITARY_ZONE_NAMES[i] + " is deprecated as a military time zone name. Use " + LegacyZones.zoneToString((ZoneOffset)MILITARY_ZONE_NAMES[i + 1]) + " instead.");
        }
        for (i = 0; i < RUBY_REGION_NAMES.length; i += 2) {
            String declaredRegion = ((String)RUBY_REGION_NAMES[i]).toUpperCase(Locale.ROOT);
            ZoneOffset declaredStandardOffset = (ZoneOffset)RUBY_REGION_NAMES[i + 1];
            ZoneOffset declaredDaylightOffset = ZoneOffset.ofTotalSeconds(declaredStandardOffset.getTotalSeconds() + 3600);
            Object[] expandedRegionNames = new Object[]{declaredRegion, declaredStandardOffset, declaredRegion + " STANDARD TIME", declaredStandardOffset, declaredRegion + " DAYLIGHT TIME", declaredDaylightOffset, declaredRegion + " DST", declaredDaylightOffset};
            for (int j = 0; j < expandedRegionNames.length; j += 2) {
                String region = (String)expandedRegionNames[j];
                ZoneOffset offset = (ZoneOffset)expandedRegionNames[j + 1];
                alternativesCaseInsensitive.put(region, offset);
                suggestionsCaseInsensitive.put(region, region + " is deprecated as a time zone name. Use " + LegacyZones.zoneToString(offset) + " instead.");
            }
        }
        for (i = 0; i < NON_SLASH_BACKWARD_REGION_NAMES.length; i += 2) {
            String region = (String)NON_SLASH_BACKWARD_REGION_NAMES[i];
            ZoneId zoneId = (ZoneId)NON_SLASH_BACKWARD_REGION_NAMES[i + 1];
            alternativesCaseSensitive.put(region, zoneId);
            suggestionsCaseSensitive.put(region, region + " is deprecated as a tzdb region name without a slash ('/'). Use " + LegacyZones.zoneToString(zoneId) + " instead.");
        }
        ALTERNATIVES_CASE_INSENSITIVE = Collections.unmodifiableMap(alternativesCaseInsensitive);
        SUGGESTIONS_CASE_INSENSITIVE = Collections.unmodifiableMap(suggestionsCaseInsensitive);
        ALTERNATIVES_CASE_SENSITIVE = Collections.unmodifiableMap(alternativesCaseSensitive);
        SUGGESTIONS_CASE_SENSITIVE = Collections.unmodifiableMap(suggestionsCaseSensitive);
    }
}

