/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config.modules;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.embulk.util.config.units.LocalFile;

public final class LocalFileModule
extends SimpleModule {
    public LocalFileModule() {
        this.addSerializer(LocalFile.class, new LocalFileSerializer());
        this.addDeserializer(LocalFile.class, new LocalFileDeserializer());
    }

    private static class LocalFileDeserializer
    extends JsonDeserializer<LocalFile> {
        private LocalFileDeserializer() {
        }

        public LocalFile deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            JsonToken currentToken = jsonParser.getCurrentToken();
            JsonToken startingToken = currentToken == JsonToken.START_OBJECT ? jsonParser.nextToken() : currentToken;
            switch (startingToken) {
                case VALUE_NULL: {
                    return null;
                }
                case FIELD_NAME: {
                    LocalFile result;
                    String keyName = jsonParser.getCurrentName();
                    if ("content".equals(keyName)) {
                        jsonParser.nextToken();
                        result = LocalFile.ofContent(jsonParser.getValueAsString());
                    } else if ("base64".equals(keyName)) {
                        jsonParser.nextToken();
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        jsonParser.readBinaryValue(context.getBase64Variant(), (OutputStream)out);
                        result = LocalFile.ofContent(out.toByteArray());
                    } else {
                        throw context.mappingException("Unknown key '" + keyName + "' to deserialize LocalFile");
                    }
                    JsonToken nextToken = jsonParser.nextToken();
                    if (nextToken != JsonToken.END_OBJECT) {
                        throw context.mappingException("Unexpected extra map keys to LocalFile");
                    }
                    return result;
                }
                case END_OBJECT: 
                case START_ARRAY: 
                case END_ARRAY: {
                    throw context.mappingException("Attempted unexpected map or array to LocalFile");
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object embeddedObject = jsonParser.getEmbeddedObject();
                    if (embeddedObject == null) {
                        return null;
                    }
                    if (LocalFile.class.isAssignableFrom(embeddedObject.getClass())) {
                        return (LocalFile)embeddedObject;
                    }
                    throw context.mappingException("Don't know how to convert embedded Object of type " + embeddedObject.getClass().getName() + " into LocalFile");
                }
            }
            return LocalFile.of(jsonParser.getValueAsString());
        }
    }

    private static class LocalFileSerializer
    extends JsonSerializer<LocalFile> {
        private LocalFileSerializer() {
        }

        public void serialize(LocalFile value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName("base64");
            jsonGenerator.writeBinary(value.getContent());
            jsonGenerator.writeEndObject();
        }
    }
}

