/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config.units;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.embulk.spi.Exec;
import org.embulk.spi.TempFileSpace;

public class LocalFile {
    private final byte[] content;
    private Path path;

    private LocalFile(Path path, byte[] content) {
        this.path = path;
        this.content = content;
    }

    private LocalFile(byte[] content) {
        this.path = null;
        this.content = content;
    }

    public static LocalFile of(File path) throws IOException {
        return LocalFile.of(path.toPath());
    }

    public static LocalFile of(Path path) throws IOException {
        return new LocalFile(path, Files.readAllBytes(path));
    }

    public static LocalFile of(String path) throws IOException {
        return LocalFile.of(Paths.get(path, new String[0]));
    }

    public static LocalFile ofContent(byte[] content) {
        return new LocalFile(content);
    }

    public static LocalFile ofContent(String content) {
        return new LocalFile(content.getBytes(StandardCharsets.UTF_8));
    }

    public File getFile() {
        return this.getPath(Exec.getTempFileSpace()).toFile();
    }

    public File getFile(TempFileSpace space) {
        return this.getPath(space).toFile();
    }

    public Path getPath() {
        return this.getPath(Exec.getTempFileSpace());
    }

    public synchronized Path getPath(TempFileSpace tempFileSpace) {
        if (this.path == null) {
            Path temp = tempFileSpace.createTempFile().toPath();
            try {
                Files.write(temp, this.content, new OpenOption[0]);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            this.path = temp;
        }
        return this.path;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentAsString() {
        return new String(this.content);
    }

    public String getContentAsString(Charset charset) {
        return new String(this.content, charset);
    }

    public InputStream newContentInputStream() {
        return new ByteArrayInputStream(this.content);
    }
}

