/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.Validator;
import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskReport;
import org.embulk.config.TaskSource;
import org.embulk.util.config.ConfigDeserializerModule;
import org.embulk.util.config.ConfigMapper;
import org.embulk.util.config.ConfigTaskSerializerModule;
import org.embulk.util.config.DataSourceImpl;
import org.embulk.util.config.DataSourceModule;
import org.embulk.util.config.TaskDeserializerModule;
import org.embulk.util.config.TaskMapper;
import org.embulk.util.config.modules.CharsetModule;
import org.embulk.util.config.modules.ColumnModule;
import org.embulk.util.config.modules.LocalFileModule;
import org.embulk.util.config.modules.SchemaModule;
import org.embulk.util.config.modules.TypeModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigMapperFactory {
    private static final Logger logger = LoggerFactory.getLogger(ConfigMapperFactory.class);
    private final List<Module> additionalModules;
    private final Validator validator;

    private ConfigMapperFactory(List<Module> additionalModules, Validator validator) {
        this.additionalModules = Collections.unmodifiableList(new ArrayList<Module>(additionalModules));
        this.validator = validator;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ConfigMapperFactory with(Validator validator, Module ... modules) {
        Builder builder = ConfigMapperFactory.builder();
        if (validator != null) {
            builder.withValidator(validator);
        }
        for (Module module : modules) {
            builder.addModule(module);
        }
        return builder.build();
    }

    public static ConfigMapperFactory with(Module ... modules) {
        return ConfigMapperFactory.with(null, modules);
    }

    public static ConfigMapperFactory withDefault() {
        return ConfigMapperFactory.builder().addDefaultModules().build();
    }

    public ConfigMapper createConfigMapper() {
        ObjectMapper objectMapper = this.mapperForConfig();
        return new ConfigMapper(objectMapper, this.validator);
    }

    public TaskMapper createTaskMapper() {
        ObjectMapper objectMapper = this.mapperForTask();
        return new TaskMapper(objectMapper);
    }

    public ConfigDiff newConfigDiff() {
        ObjectMapper objectMapper = this.mapperForOthers();
        return new DataSourceImpl(objectMapper.createObjectNode(), objectMapper);
    }

    public ConfigSource newConfigSource() {
        ObjectMapper objectMapper = this.mapperForConfig();
        return new DataSourceImpl(objectMapper.createObjectNode(), objectMapper);
    }

    public TaskReport newTaskReport() {
        ObjectMapper objectMapper = this.mapperForOthers();
        return new DataSourceImpl(objectMapper.createObjectNode(), objectMapper);
    }

    public TaskSource newTaskSource() {
        ObjectMapper objectMapper = this.mapperForTask();
        return new DataSourceImpl(objectMapper.createObjectNode(), objectMapper);
    }

    private ObjectMapper mapperForConfig() {
        ObjectMapper objectMapper = new ObjectMapper();
        for (Module module : this.additionalModules) {
            objectMapper.registerModule(module);
        }
        objectMapper.registerModule((Module)new ConfigTaskSerializerModule(objectMapper));
        objectMapper.registerModule((Module)new ConfigDeserializerModule(objectMapper, this.validator));
        objectMapper.registerModule((Module)new DataSourceModule(objectMapper));
        return objectMapper;
    }

    private ObjectMapper mapperForTask() {
        ObjectMapper objectMapper = new ObjectMapper();
        for (Module module : this.additionalModules) {
            objectMapper.registerModule(module);
        }
        objectMapper.registerModule((Module)new ConfigTaskSerializerModule(objectMapper));
        objectMapper.registerModule((Module)new TaskDeserializerModule(objectMapper, this.validator));
        objectMapper.registerModule((Module)new DataSourceModule(objectMapper));
        return objectMapper;
    }

    private ObjectMapper mapperForOthers() {
        ObjectMapper objectMapper = new ObjectMapper();
        for (Module module : this.additionalModules) {
            objectMapper.registerModule(module);
        }
        objectMapper.registerModule((Module)new DataSourceModule(objectMapper));
        return objectMapper;
    }

    public static class Builder {
        private final ArrayList<Module> additionalModules = new ArrayList();
        private Validator validator = null;

        private Builder() {
        }

        public ConfigMapperFactory build() {
            return new ConfigMapperFactory(this.additionalModules, this.validator);
        }

        public Builder addDefaultModules() {
            this.addModule((Module)new ColumnModule());
            this.addModule((Module)new SchemaModule());
            this.addModule((Module)new TypeModule());
            this.addModule((Module)new CharsetModule());
            this.addModule((Module)new LocalFileModule());
            this.addModule((Module)new Jdk8Module());
            return this;
        }

        public Builder addModule(Module module) {
            if (module == null) {
                throw new NullPointerException("ConfigMapperFactory.Builder#addModule does not accept null.");
            }
            for (Module m : this.additionalModules) {
                if (!m.getClass().equals(module.getClass())) continue;
                logger.warn("Jackson Module {} is already added. It may be duplicated.", module.getClass());
            }
            this.additionalModules.add(module);
            return this;
        }

        public Builder withValidator(Validator validator) {
            if (validator == null) {
                throw new NullPointerException("ConfigMapperFactory.Builder#withValidator does not accept null.");
            }
            if (this.validator != null) {
                throw new IllegalStateException("ConfigMapperFactory.Builder accepts withValidator just once.");
            }
            this.validator = validator;
            return this;
        }
    }
}

