/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config.units;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import org.embulk.config.ConfigSource;
import org.embulk.spi.Column;
import org.embulk.spi.Exec;
import org.embulk.spi.type.TimestampType;
import org.embulk.spi.type.Type;

public class ColumnConfig {
    private final String name;
    private final Type type;
    private final ConfigSource option;

    @Deprecated
    public ColumnConfig(String name, Type type, String format) {
        this.name = name;
        this.type = type;
        this.option = Exec.newConfigSource();
        if (format != null) {
            this.option.set("format", (Object)format);
        }
    }

    public ColumnConfig(String name, Type type, ConfigSource option) {
        this.name = name;
        this.type = type;
        this.option = option;
    }

    @JsonCreator
    public ColumnConfig(ConfigSource config) {
        this.name = (String)config.get(String.class, "name");
        this.type = (Type)config.get(Type.class, "type");
        this.option = config.deepCopy();
        this.option.remove("name");
        this.option.remove("type");
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public ConfigSource getOption() {
        return this.option;
    }

    @JsonValue
    public ConfigSource getConfigSource() {
        ConfigSource config = this.option.deepCopy();
        config.set("name", (Object)this.name);
        config.set("type", (Object)this.type);
        return config;
    }

    @Deprecated
    public String getFormat() {
        return (String)this.option.get(String.class, "format", null);
    }

    public Column toColumn(int index) {
        String format = (String)this.option.get(String.class, "format", null);
        if (this.type instanceof TimestampType && format != null) {
            return new Column(index, this.name, (Type)((TimestampType)this.type).withFormat(format));
        }
        return new Column(index, this.name, this.type);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof ColumnConfig)) {
            return false;
        }
        ColumnConfig other = (ColumnConfig)otherObject;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.option, other.option);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public String toString() {
        return String.format("ColumnConfig[%s, %s]", this.getName(), this.getType());
    }
}

