/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.embulk.config.ConfigException;

public class TaskValidationException
extends ConfigException {
    <T> TaskValidationException(Set<ConstraintViolation<T>> violations) {
        super(TaskValidationException.formatMessage(violations), (Throwable)new ConstraintViolationException(violations));
    }

    private static <T> String formatMessage(Set<ConstraintViolation<T>> violations) {
        StringBuilder sb = new StringBuilder();
        sb.append("Configuration violates constraints validated in task definition.");
        for (ConstraintViolation<T> violation : violations) {
            sb.append(" '");
            sb.append(violation.getPropertyPath());
            sb.append("' ");
            sb.append(violation.getMessage());
            sb.append(" but got ");
            sb.append(violation.getInvalidValue());
            sb.append('.');
        }
        return sb.toString();
    }
}

