/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config;

import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

final class Version {
    static final com.fasterxml.jackson.core.Version JACKSON_MODULE_VERSION = Version.getVersion();
    private static final String GROUP_ID = "org.embulk";
    private static final String ARTIFACT_ID = "embulk-util-config";

    private Version() {
    }

    static com.fasterxml.jackson.core.Version parseVersionForTesting(String version) {
        return Version.parseVersion(version);
    }

    private static com.fasterxml.jackson.core.Version getVersion() {
        try {
            return Version.parseVersion(Version.getImplementationVersion());
        }
        catch (Throwable any) {
            return com.fasterxml.jackson.core.Version.unknownVersion();
        }
    }

    private static com.fasterxml.jackson.core.Version parseVersion(String implementationVersion) {
        String snapshotInfo;
        String version;
        String[] versionAndSnapshotInfo = implementationVersion.split("-", 2);
        if (versionAndSnapshotInfo.length == 1) {
            version = versionAndSnapshotInfo[0];
            snapshotInfo = null;
        } else if (versionAndSnapshotInfo.length == 2) {
            version = versionAndSnapshotInfo[0];
            snapshotInfo = versionAndSnapshotInfo[1];
        } else {
            throw new IllegalArgumentException("Empty version string.");
        }
        String[] versionSplit = version.split("\\.");
        if (versionSplit.length == 1) {
            return new com.fasterxml.jackson.core.Version(Integer.parseInt(versionSplit[0]), 0, 0, snapshotInfo, GROUP_ID, ARTIFACT_ID);
        }
        if (versionSplit.length == 2) {
            return new com.fasterxml.jackson.core.Version(Integer.parseInt(versionSplit[0]), Integer.parseInt(versionSplit[1]), 0, snapshotInfo, GROUP_ID, ARTIFACT_ID);
        }
        if (versionSplit.length == 3) {
            return new com.fasterxml.jackson.core.Version(Integer.parseInt(versionSplit[0]), Integer.parseInt(versionSplit[1]), Integer.parseInt(versionSplit[2]), snapshotInfo, GROUP_ID, ARTIFACT_ID);
        }
        if (versionSplit.length == 0) {
            throw new IllegalArgumentException("Empty version.");
        }
        throw new IllegalArgumentException("3+ digits in version.");
    }

    private static String getImplementationVersion() {
        try {
            return Version.getManifestImplementationVersion();
        }
        catch (Throwable throwable) {
            try {
                return System.getProperty("org.embulk.embulk_util_config.version");
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
    }

    private static String getManifestImplementationVersion() throws Exception {
        Manifest manifest;
        URL selfJarUrl = Version.class.getProtectionDomain().getCodeSource().getLocation();
        if (selfJarUrl == null || !selfJarUrl.getProtocol().equals("file")) {
            throw new Exception();
        }
        String selfJarPathString = selfJarUrl.getPath();
        if (selfJarPathString == null || selfJarPathString.isEmpty()) {
            throw new Exception();
        }
        try (JarFile selfJarFile = new JarFile(selfJarPathString);){
            manifest = selfJarFile.getManifest();
        }
        if (manifest == null) {
            throw new Exception();
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        String implementationVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        if (implementationVersion == null) {
            throw new Exception();
        }
        return implementationVersion;
    }
}

