/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigException;
import org.embulk.config.ConfigSource;
import org.embulk.config.DataSource;
import org.embulk.config.TaskReport;
import org.embulk.config.TaskSource;
import org.embulk.util.config.Compat;

public final class DataSourceImpl
implements ConfigSource,
TaskSource,
TaskReport,
ConfigDiff {
    private final ObjectNode data;
    private final ObjectMapper objectMapper;

    DataSourceImpl(ObjectNode data, ObjectMapper objectMapper) {
        this.data = data;
        this.objectMapper = objectMapper;
    }

    public List<String> getAttributeNames() {
        ArrayList copy = new ArrayList();
        this.data.fieldNames().forEachRemaining(copy::add);
        return Collections.unmodifiableList(copy);
    }

    public boolean isEmpty() {
        return !this.data.fieldNames().hasNext();
    }

    public boolean has(String attrName) {
        return this.data.has(attrName);
    }

    public <E> E get(Class<E> type, String attrName) {
        JsonNode json = this.data.get(attrName);
        if (json == null) {
            throw new ConfigException("Attribute " + attrName + " is required but not set.");
        }
        try {
            return (E)this.objectMapper.readValue(json.traverse(), type);
        }
        catch (IOException ex) {
            throw new ConfigException((Throwable)ex);
        }
    }

    public <E> E get(Class<E> type, String attrName, E defaultValue) {
        JsonNode json = this.data.get(attrName);
        if (json == null) {
            return defaultValue;
        }
        try {
            return (E)this.objectMapper.readValue(json.traverse(), type);
        }
        catch (IOException ex) {
            throw new ConfigException((Throwable)ex);
        }
    }

    public DataSourceImpl getNested(String attrName) {
        JsonNode json = this.data.get(attrName);
        if (json == null) {
            throw new ConfigException("Attribute " + attrName + " is required but not set.");
        }
        if (!json.isObject()) {
            throw new ConfigException("Attribute " + attrName + " must be an object.");
        }
        return new DataSourceImpl((ObjectNode)json, this.objectMapper);
    }

    public DataSourceImpl getNestedOrSetEmpty(String attrName) {
        JsonNode json = this.data.get(attrName);
        if (json == null) {
            ObjectNode object = this.data.objectNode();
            object.set(attrName, json);
            return new DataSourceImpl(object, this.objectMapper);
        }
        if (!json.isObject()) {
            throw new ConfigException("Attribute " + attrName + " must be an object.");
        }
        return new DataSourceImpl((ObjectNode)json, this.objectMapper);
    }

    public DataSourceImpl getNestedOrGetEmpty(String attrName) {
        JsonNode json = this.data.get(attrName);
        if (json == null) {
            ObjectNode object = this.data.objectNode();
            return new DataSourceImpl(object, this.objectMapper);
        }
        if (!json.isObject()) {
            throw new ConfigException("Attribute " + attrName + " must be an object.");
        }
        return new DataSourceImpl((ObjectNode)json, this.objectMapper);
    }

    public DataSourceImpl set(String attrName, Object v) {
        if (v == null) {
            this.remove(attrName);
        } else {
            this.data.set(attrName, this.objectMapper.valueToTree(v));
        }
        return this;
    }

    public DataSourceImpl setNested(String attrName, DataSource v) {
        if (v == null) {
            this.data.set(attrName, null);
        } else {
            JsonNode vJsonNode;
            String vJsonStringified;
            try {
                vJsonStringified = Compat.toJson(v);
            }
            catch (IOException ex) {
                throw new ConfigException("Unexpected failure in stringifying DataSource as JSON.", (Throwable)ex);
            }
            if (vJsonStringified == null) {
                throw new ConfigException((Throwable)new NullPointerException("DataSource#setNested accepts only valid DataSource."));
            }
            try {
                vJsonNode = (JsonNode)this.objectMapper.readValue(vJsonStringified, JsonNode.class);
            }
            catch (IOException ex) {
                throw new ConfigException((Throwable)ex);
            }
            if (!vJsonNode.isObject()) {
                throw new ConfigException((Throwable)new ClassCastException("DataSource#setNested accepts only valid JSON object."));
            }
            this.data.set(attrName, (JsonNode)((ObjectNode)vJsonNode));
        }
        return this;
    }

    public DataSourceImpl setAll(DataSource other) {
        JsonNode otherJsonNode;
        String otherJsonStringified;
        if (other == null) {
            throw new ConfigException((Throwable)new NullPointerException("DataSource#setAll accepts only non-null value."));
        }
        try {
            otherJsonStringified = Compat.toJson(other);
        }
        catch (IOException ex) {
            throw new ConfigException("Unexpected failure in stringifying DataSource as JSON.", (Throwable)ex);
        }
        if (otherJsonStringified == null) {
            throw new ConfigException((Throwable)new NullPointerException("DataSource#setAll accepts only valid DataSource."));
        }
        try {
            otherJsonNode = (JsonNode)this.objectMapper.readValue(otherJsonStringified, JsonNode.class);
        }
        catch (IOException ex) {
            throw new ConfigException((Throwable)ex);
        }
        if (!otherJsonNode.isObject()) {
            throw new ConfigException((Throwable)new ClassCastException("DataSource#setAll accepts only valid JSON object."));
        }
        ObjectNode otherObjectNode = (ObjectNode)otherJsonNode;
        for (Map.Entry field : () -> otherObjectNode.fields()) {
            this.data.set((String)field.getKey(), (JsonNode)field.getValue());
        }
        return this;
    }

    public DataSourceImpl remove(String attrName) {
        this.data.remove(attrName);
        return this;
    }

    public DataSourceImpl deepCopy() {
        return new DataSourceImpl(this.data.deepCopy(), this.objectMapper);
    }

    public DataSourceImpl merge(DataSource other) {
        JsonNode otherJsonNode;
        String otherJsonStringified;
        if (other == null) {
            throw new ConfigException((Throwable)new NullPointerException("DataSource#merge accepts only non-null value."));
        }
        try {
            otherJsonStringified = Compat.toJson(other);
        }
        catch (IOException ex) {
            throw new ConfigException("Unexpected failure in stringifying DataSource as JSON.", (Throwable)ex);
        }
        if (otherJsonStringified == null) {
            throw new ConfigException((Throwable)new NullPointerException("DataSource#merge accepts only valid DataSource."));
        }
        try {
            otherJsonNode = (JsonNode)this.objectMapper.readValue(otherJsonStringified, JsonNode.class);
        }
        catch (IOException ex) {
            throw new ConfigException((Throwable)ex);
        }
        if (!otherJsonNode.isObject()) {
            throw new ConfigException((Throwable)new ClassCastException("DataSource#setAll accepts only valid JSON object."));
        }
        DataSourceImpl.mergeJsonObject(this.data, (ObjectNode)otherJsonNode);
        return this;
    }

    public String toJson() {
        try {
            return this.objectMapper.writeValueAsString((Object)this.data);
        }
        catch (JsonProcessingException ex) {
            throw new ConfigException((Throwable)ex);
        }
    }

    @Deprecated
    public <T> T loadConfig(Class<T> taskType) {
        throw new UnsupportedOperationException("org.embulk.util.config.DataSourceImpl does not implement loadConfig.");
    }

    @Deprecated
    public <T> T loadTask(Class<T> taskType) {
        try {
            return (T)this.objectMapper.readValue(this.data.traverse(), taskType);
        }
        catch (IOException ex) {
            throw new ConfigException((Throwable)ex);
        }
    }

    @Deprecated
    public ObjectNode getObjectNode() {
        return this.data;
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean equals(Object other) {
        JsonNode otherJsonNode;
        String otherJsonStringified;
        if (other == null) {
            return false;
        }
        if (!(other instanceof DataSource)) {
            return false;
        }
        DataSource otherDataSource = (DataSource)other;
        try {
            otherJsonStringified = Compat.toJson(otherDataSource);
        }
        catch (IOException ex) {
            throw new ConfigException("Unexpected failure in stringifying DataSource as JSON.", (Throwable)ex);
        }
        if (otherJsonStringified == null) {
            return false;
        }
        try {
            otherJsonNode = (JsonNode)this.objectMapper.readValue(otherJsonStringified, JsonNode.class);
        }
        catch (IOException ex) {
            return false;
        }
        if (!otherJsonNode.isObject()) {
            return false;
        }
        return this.data.equals((Object)((ObjectNode)otherJsonNode));
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    private static void mergeJsonObject(ObjectNode src, ObjectNode other) {
        Iterator it = other.fields();
        while (it.hasNext()) {
            Map.Entry pair = (Map.Entry)it.next();
            JsonNode s = src.get((String)pair.getKey());
            JsonNode v = (JsonNode)pair.getValue();
            if (v.isObject() && s != null && s.isObject()) {
                DataSourceImpl.mergeJsonObject((ObjectNode)s, (ObjectNode)v);
                continue;
            }
            if (v.isArray() && s != null && s.isArray()) {
                DataSourceImpl.mergeJsonArray((ArrayNode)s, (ArrayNode)v);
                continue;
            }
            src.replace((String)pair.getKey(), v);
        }
    }

    private static void mergeJsonArray(ArrayNode src, ArrayNode other) {
        for (int i = 0; i < other.size(); ++i) {
            JsonNode s = src.get(i);
            JsonNode v = other.get(i);
            if (s == null) {
                src.add(v);
                continue;
            }
            if (v.isObject() && s.isObject()) {
                DataSourceImpl.mergeJsonObject((ObjectNode)s, (ObjectNode)v);
                continue;
            }
            if (v.isArray() && s.isArray()) {
                DataSourceImpl.mergeJsonArray((ArrayNode)s, (ArrayNode)v);
                continue;
            }
            src.remove(i);
            src.insert(i, v);
        }
    }
}

