/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.embulk.util.config.Config;
import org.embulk.util.config.ConfigDefault;
import org.embulk.util.config.Tasks;

final class TaskField {
    private final Method getterMethod;
    private final String name;
    private final Type returnType;
    private final String defaultValueInJsonString;

    private TaskField(Method getterMethod, String name, Type returnType, String defaultValueInJsonString) {
        this.getterMethod = getterMethod;
        this.name = name;
        this.returnType = returnType;
        this.defaultValueInJsonString = defaultValueInJsonString;
    }

    static TaskField of(Method getterMethod) {
        if (getterMethod.getParameterTypes().length != 0) {
            return null;
        }
        Optional<String> name = Tasks.getFieldNameFromGetter(getterMethod.getName());
        if (!name.isPresent()) {
            return null;
        }
        Type returnType = getterMethod.getGenericReturnType();
        ConfigDefault annotationConfigDefault = getterMethod.getAnnotation(ConfigDefault.class);
        if (annotationConfigDefault != null && !annotationConfigDefault.value().isEmpty()) {
            return new TaskField(getterMethod, name.get(), returnType, annotationConfigDefault.value());
        }
        return new TaskField(getterMethod, name.get(), returnType, null);
    }

    Method getGetterMethod() {
        return this.getterMethod;
    }

    String getName() {
        return this.name;
    }

    Type getReturnType() {
        return this.returnType;
    }

    Optional<String> getDefaultValueInJsonString() {
        return Optional.ofNullable(this.defaultValueInJsonString);
    }

    String getFieldNameMappedFromConfigSourceJson() {
        Config annotationConfig = this.getterMethod.getAnnotation(Config.class);
        if (annotationConfig != null) {
            return annotationConfig.value();
        }
        return null;
    }

    String getFieldNameMappedFromTaskSourceJson() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.getterMethod, this.name, this.returnType, this.defaultValueInJsonString);
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof TaskField)) {
            return false;
        }
        TaskField other = (TaskField)otherObject;
        return Objects.equals(this.getterMethod, other.getterMethod) && Objects.equals(this.name, other.name) && Objects.equals(this.returnType, other.returnType) && Objects.equals(this.defaultValueInJsonString, other.defaultValueInJsonString);
    }
}

