/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.embulk.config.DataSource;
import org.embulk.config.TaskSource;
import org.embulk.util.config.Compat;
import org.embulk.util.config.Task;

public final class TaskMapper {
    private final ObjectMapper objectMapper;

    TaskMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T extends Task> T map(TaskSource task, Class<T> taskType) {
        Task value;
        ObjectNode objectNode;
        try {
            objectNode = Compat.rebuildObjectNode((DataSource)task);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("org.embulk.config.TaskSource#toJson() returned an invalid JSON.", ex);
        }
        try {
            value = (Task)this.objectMapper.readValue(objectNode.traverse(), taskType);
        }
        catch (JsonMappingException ex) {
            throw new UncheckedIOException("Failed to map a JSON value into some object.", (IOException)((Object)ex));
        }
        catch (JsonParseException ex) {
            throw new UncheckedIOException("Unexpected failure in parsing ObjectNode rebuilt from org.embulk.config.TaskSource.", (IOException)((Object)ex));
        }
        catch (JsonProcessingException ex) {
            throw new UncheckedIOException("Unexpected failure in processing ObjectNode rebuilt from org.embulk.config.TaskSource.", (IOException)((Object)ex));
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Unexpected I/O error in ObjectNode rebuilt from org.embulk.config.TaskSource.", ex);
        }
        return (T)value;
    }
}

