/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.embulk.config.DataSource;
import org.embulk.util.config.rebuild.ObjectNodeRebuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Compat {
    private static final ObjectMapper SIMPLE_MAPPER = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(Compat.class);

    private Compat() {
    }

    static String toJson(DataSource source) throws IOException {
        Optional<String> jsonString = Compat.callToJsonIfAvailable(source);
        if (jsonString.isPresent()) {
            return jsonString.get();
        }
        ObjectNode objectNode = Compat.callGetObjectNodeAndRebuildIfAvailable(source, SIMPLE_MAPPER);
        return SIMPLE_MAPPER.writeValueAsString((Object)objectNode);
    }

    static ObjectNode rebuildObjectNode(DataSource source) throws IOException {
        Optional<String> jsonString = Compat.callToJsonIfAvailable(source);
        if (jsonString.isPresent()) {
            JsonNode jsonNode = SIMPLE_MAPPER.readTree(jsonString.get());
            if (jsonNode == null) {
                throw new NullPointerException("DataSource(Impl)#toJson() returned null.");
            }
            if (!jsonNode.isObject()) {
                throw new ClassCastException("DataSource(Impl)#toJson() returned not a JSON object: " + jsonNode.getClass().getCanonicalName());
            }
            return (ObjectNode)jsonNode;
        }
        return Compat.callGetObjectNodeAndRebuildIfAvailable(source, SIMPLE_MAPPER);
    }

    private static Optional<String> callToJsonIfAvailable(DataSource source) {
        Object jsonStringObject;
        Method toJson = Compat.getToJsonMethod(source);
        if (toJson == null) {
            return Optional.empty();
        }
        try {
            jsonStringObject = toJson.invoke((Object)source, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw new IllegalStateException("DataSource(Impl)#toJson() threw unexpected Exception.", targetException);
        }
        catch (IllegalAccessException ex) {
            logger.debug("DataSource(Impl)#toJson is not accessible unexpectedly. DataSource: {}, toJson: {}, ", source.getClass(), (Object)toJson);
            throw new IllegalStateException("DataSource(Impl)#toJson() is not accessible.", ex);
        }
        if (jsonStringObject == null) {
            throw new NullPointerException("DataSource(Impl)#toJson() returned null.");
        }
        if (!(jsonStringObject instanceof String)) {
            throw new ClassCastException("DataSource(Impl)#toJson() returned not a String: " + jsonStringObject.getClass().getCanonicalName());
        }
        return Optional.of((String)jsonStringObject);
    }

    private static ObjectNode callGetObjectNodeAndRebuildIfAvailable(DataSource source, ObjectMapper mapper) {
        Object coreObjectNode;
        Class<?> coreDataSourceImplClass = source.getClass();
        if (!coreDataSourceImplClass.getCanonicalName().equals("org.embulk.config.DataSourceImpl")) {
            throw new ClassCastException("DataSource specified is not org.embulk.config.DataSourceImpl. The DataSource instance is unexpected to implement getObjectNode(). DataSource class: " + source.getClass());
        }
        Method getObjectNode = Compat.getGetObjectNodeMethod(coreDataSourceImplClass);
        if (getObjectNode == null) {
            throw new IllegalStateException("org.embulk.config.DataSourceImpl does not implement getObjectNode().");
        }
        try {
            coreObjectNode = getObjectNode.invoke((Object)source, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw new IllegalStateException("DataSourceImpl#getObjectNode() threw unexpected Exception.", targetException);
        }
        catch (IllegalAccessException ex) {
            logger.debug("DataSourceImpl#getObjectNode is not accessible unexpectedly. DataSourceImpl: {}, getObjectNode: {}, ", source.getClass(), (Object)getObjectNode);
            throw new IllegalStateException("DataSourceImpl#getObjectNode() is not accessible.", ex);
        }
        return ObjectNodeRebuilder.rebuild(coreObjectNode, mapper);
    }

    private static Method getToJsonMethod(DataSource source) {
        try {
            return DataSource.class.getMethod("toJson", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class<?> dataSourceImplClass = source.getClass();
            try {
                return dataSourceImplClass.getMethod("toJson", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }
    }

    private static Method getGetObjectNodeMethod(Class<? extends DataSource> coreDataSourceImplClass) {
        try {
            return coreDataSourceImplClass.getMethod("getObjectNode", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }
}

