/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config.modules;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Optional;
import org.embulk.util.config.modules.LegacyZones;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZoneIdModule
extends SimpleModule {
    private static final Logger logger = LoggerFactory.getLogger(ZoneIdModule.class);

    private ZoneIdModule(boolean usesLegacyNames) {
        this.addSerializer(ZoneId.class, new ZoneIdSerializer());
        this.addDeserializer(ZoneId.class, (JsonDeserializer)new ZoneIdDeserializer(usesLegacyNames));
    }

    public ZoneIdModule() {
        this(false);
    }

    public static ZoneIdModule withLegacyNames() {
        return new ZoneIdModule(true);
    }

    private static class ZoneIdDeserializer
    extends FromStringDeserializer<ZoneId> {
        private final boolean usesLegacyNames;

        public ZoneIdDeserializer(boolean usesLegacyNames) {
            super(ZoneId.class);
            this.usesLegacyNames = usesLegacyNames;
        }

        protected ZoneId _deserialize(String value, DeserializationContext context) throws JsonMappingException {
            Optional<ZoneId> alternative;
            Optional<String> suggestion = LegacyZones.getSuggestion(value);
            if (suggestion.isPresent()) {
                if (this.usesLegacyNames) {
                    logger.warn(suggestion.get());
                } else {
                    throw JsonMappingException.from((JsonParser)context.getParser(), (String)suggestion.get());
                }
            }
            if ((alternative = LegacyZones.getAlternative(value)).isPresent()) {
                logger.warn("\"{}\" is recognized as \"{}\" to be compatible with the legacy style.", (Object)value, (Object)alternative.get());
                return alternative.get();
            }
            try {
                return ZoneId.of(value);
            }
            catch (DateTimeException ex) {
                throw JsonMappingException.from((JsonParser)context.getParser(), (String)String.format("\"%s\" is not recognized as a timezone name.", value), (Throwable)ex);
            }
        }
    }

    private static class ZoneIdSerializer
    extends JsonSerializer<ZoneId> {
        private ZoneIdSerializer() {
        }

        public void serialize(ZoneId value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeString(value.getId());
        }
    }
}

