/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.csv;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.embulk.util.csv.EndOfFileInQuotedFieldException;
import org.embulk.util.csv.InvalidCharacterAfterQuoteException;
import org.embulk.util.csv.QuotedFieldLengthLimitExceededException;
import org.embulk.util.csv.RecordDoesNotHaveExpectedColumnException;
import org.embulk.util.csv.RecordHasUnexpectedTrailingColumnException;

public class CsvTokenizer {
    public static final char NO_QUOTE = '\u0000';
    public static final char NO_ESCAPE = '\u0000';
    private static final char END_OF_LINE = '\u0000';
    private final Iterator<String> iterator;
    private final char delimiterChar;
    private final String delimiterFollowingString;
    private final char quote;
    private final char escape;
    private final String newline;
    private final boolean trimIfNotQuoted;
    private final QuotesInQuotedFields quotesInQuotedFields;
    private final long maxQuotedFieldLength;
    private final String commentLineMarker;
    private final String nullString;
    private final List<String> quotedValueLines;
    private final Deque<String> unreadLines;
    private RecordState recordState;
    private long lineNumber;
    private String line;
    private int linePos;
    private boolean wasQuotedColumn;

    private CsvTokenizer(Iterator<String> iterator, char delimiterChar, String delimiterFollowingString, char quote, char escape, String newline, boolean trimIfNotQuoted, QuotesInQuotedFields quotesInQuotedFields, long maxQuotedFieldLength, String commentLineMarker, String nullString) {
        this.delimiterChar = delimiterChar;
        this.delimiterFollowingString = delimiterFollowingString;
        this.quote = quote;
        this.escape = escape;
        this.newline = newline;
        this.trimIfNotQuoted = trimIfNotQuoted;
        this.quotesInQuotedFields = quotesInQuotedFields;
        this.maxQuotedFieldLength = maxQuotedFieldLength;
        this.commentLineMarker = commentLineMarker;
        this.nullString = nullString;
        this.quotedValueLines = new ArrayList<String>();
        this.unreadLines = new ArrayDeque<String>();
        this.iterator = iterator;
        this.recordState = RecordState.END;
        this.lineNumber = 0L;
        this.line = null;
        this.linePos = 0;
        this.wasQuotedColumn = false;
    }

    public static Builder builder(String delimiter) {
        return new Builder(delimiter);
    }

    public long getCurrentLineNumber() {
        return this.lineNumber;
    }

    public boolean skipHeaderLine() {
        if (!this.iterator.hasNext()) {
            return false;
        }
        this.iterator.next();
        ++this.lineNumber;
        return true;
    }

    public String skipCurrentLine() {
        String skippedLine;
        if (this.quotedValueLines.isEmpty()) {
            skippedLine = this.line;
        } else {
            skippedLine = this.quotedValueLines.remove(0);
            this.unreadLines.addAll(this.quotedValueLines);
            this.lineNumber -= (long)this.quotedValueLines.size();
            if (this.line != null) {
                this.unreadLines.add(this.line);
                --this.lineNumber;
            }
            this.quotedValueLines.clear();
        }
        this.recordState = RecordState.END;
        return skippedLine;
    }

    public boolean nextRecord() {
        return this.nextRecord(true);
    }

    public boolean nextRecord(boolean skipEmptyLine) {
        if (this.recordState != RecordState.END) {
            throw new RecordHasUnexpectedTrailingColumnException();
        }
        boolean hasNext = this.nextLine(skipEmptyLine);
        if (hasNext) {
            this.recordState = RecordState.NOT_END;
            return true;
        }
        return false;
    }

    private boolean nextLine(boolean skipEmptyLine) {
        boolean skip;
        do {
            if (!this.unreadLines.isEmpty()) {
                this.line = this.unreadLines.removeFirst();
            } else {
                if (!this.iterator.hasNext()) {
                    this.line = null;
                    return false;
                }
                this.line = this.iterator.next();
            }
            this.linePos = 0;
            ++this.lineNumber;
        } while (skip = skipEmptyLine && (this.line.isEmpty() || this.commentLineMarker != null && this.line.startsWith(this.commentLineMarker)));
        return true;
    }

    public boolean hasNextColumn() {
        return this.recordState == RecordState.NOT_END;
    }

    public String nextColumn() {
        if (!this.hasNextColumn()) {
            throw new RecordDoesNotHaveExpectedColumnException();
        }
        this.wasQuotedColumn = false;
        this.quotedValueLines.clear();
        int valueStartPos = this.linePos;
        int valueEndPos = 0;
        StringBuilder quotedValue = null;
        ColumnState columnState = ColumnState.BEGIN;
        block8: while (true) {
            char c = this.nextChar();
            switch (columnState) {
                case BEGIN: {
                    if (this.isDelimiter(c)) {
                        if (this.delimiterFollowingString == null) {
                            return "";
                        }
                        if (this.isDelimiterFollowingFrom(this.linePos)) {
                            this.linePos += this.delimiterFollowingString.length();
                            return "";
                        }
                    }
                    if (this.isEndOfLine(c)) {
                        this.recordState = RecordState.END;
                        return "";
                    }
                    if (this.isSpace(c) && this.trimIfNotQuoted) {
                        columnState = ColumnState.FIRST_TRIM;
                        break;
                    }
                    if (this.isQuote(c)) {
                        valueStartPos = this.linePos;
                        this.wasQuotedColumn = true;
                        quotedValue = new StringBuilder();
                        columnState = ColumnState.QUOTED_VALUE;
                        break;
                    }
                    columnState = ColumnState.VALUE;
                    break;
                }
                case FIRST_TRIM: {
                    if (this.isDelimiter(c)) {
                        if (this.delimiterFollowingString == null) {
                            return "";
                        }
                        if (this.isDelimiterFollowingFrom(this.linePos)) {
                            this.linePos += this.delimiterFollowingString.length();
                            return "";
                        }
                    }
                    if (this.isEndOfLine(c)) {
                        this.recordState = RecordState.END;
                        return "";
                    }
                    if (this.isQuote(c)) {
                        valueStartPos = this.linePos;
                        this.wasQuotedColumn = true;
                        quotedValue = new StringBuilder();
                        columnState = ColumnState.QUOTED_VALUE;
                        break;
                    }
                    if (this.isSpace(c)) continue block8;
                    valueStartPos = this.linePos - 1;
                    columnState = ColumnState.VALUE;
                    break;
                }
                case VALUE: {
                    if (this.isDelimiter(c)) {
                        if (this.delimiterFollowingString == null) {
                            return this.line.substring(valueStartPos, this.linePos - 1);
                        }
                        if (this.isDelimiterFollowingFrom(this.linePos)) {
                            String value = this.line.substring(valueStartPos, this.linePos - 1);
                            this.linePos += this.delimiterFollowingString.length();
                            return value;
                        }
                    }
                    if (this.isEndOfLine(c)) {
                        this.recordState = RecordState.END;
                        return this.line.substring(valueStartPos, this.linePos);
                    }
                    if (!this.isSpace(c) || !this.trimIfNotQuoted) continue block8;
                    valueEndPos = this.linePos - 1;
                    columnState = ColumnState.LAST_TRIM_OR_VALUE;
                    break;
                }
                case LAST_TRIM_OR_VALUE: {
                    if (this.isDelimiter(c)) {
                        if (this.delimiterFollowingString == null) {
                            return this.line.substring(valueStartPos, valueEndPos);
                        }
                        if (this.isDelimiterFollowingFrom(this.linePos)) {
                            this.linePos += this.delimiterFollowingString.length();
                            return this.line.substring(valueStartPos, valueEndPos);
                        }
                    }
                    if (this.isEndOfLine(c)) {
                        this.recordState = RecordState.END;
                        return this.line.substring(valueStartPos, valueEndPos);
                    }
                    if (this.isSpace(c)) continue block8;
                    columnState = ColumnState.VALUE;
                    break;
                }
                case QUOTED_VALUE: {
                    char next;
                    if (this.isEndOfLine(c)) {
                        quotedValue.append(this.line.substring(valueStartPos, this.linePos));
                        quotedValue.append(this.newline);
                        this.quotedValueLines.add(this.line);
                        if (!this.nextLine(false)) {
                            throw new EndOfFileInQuotedFieldException();
                        }
                        valueStartPos = 0;
                        break;
                    }
                    if (this.isQuote(c)) {
                        next = this.peekNextChar();
                        char nextNext = this.peekNextNextChar();
                        if (this.isQuote(next) && (this.quotesInQuotedFields != QuotesInQuotedFields.ACCEPT_STRAY_QUOTES_ASSUMING_NO_DELIMITERS_IN_FIELDS || !this.isDelimiter(nextNext) && !this.isEndOfLine(nextNext))) {
                            quotedValue.append(this.line.substring(valueStartPos, this.linePos));
                            valueStartPos = ++this.linePos;
                            break;
                        }
                        if (this.quotesInQuotedFields == QuotesInQuotedFields.ACCEPT_STRAY_QUOTES_ASSUMING_NO_DELIMITERS_IN_FIELDS && !this.isDelimiter(next) && !this.isEndOfLine(next)) {
                            if ((long)(this.linePos - valueStartPos + quotedValue.length()) <= this.maxQuotedFieldLength) continue block8;
                            throw new QuotedFieldLengthLimitExceededException(this.maxQuotedFieldLength);
                        }
                        quotedValue.append(this.line.substring(valueStartPos, this.linePos - 1));
                        columnState = ColumnState.AFTER_QUOTED_VALUE;
                        break;
                    }
                    if (this.isEscape(c)) {
                        next = this.peekNextChar();
                        if (this.isEndOfLine(c)) {
                            quotedValue.append(this.line.substring(valueStartPos, this.linePos));
                            this.quotedValueLines.add(this.line);
                            if (!this.nextLine(false)) {
                                throw new EndOfFileInQuotedFieldException();
                            }
                            valueStartPos = 0;
                            break;
                        }
                        if (!this.isQuote(next) && !this.isEscape(next)) continue block8;
                        quotedValue.append(this.line.substring(valueStartPos, this.linePos - 1));
                        quotedValue.append(next);
                        valueStartPos = ++this.linePos;
                        break;
                    }
                    if ((long)(this.linePos - valueStartPos + quotedValue.length()) <= this.maxQuotedFieldLength) continue block8;
                    throw new QuotedFieldLengthLimitExceededException(this.maxQuotedFieldLength);
                }
                case AFTER_QUOTED_VALUE: {
                    if (this.isDelimiter(c)) {
                        if (this.delimiterFollowingString == null) {
                            return quotedValue.toString();
                        }
                        if (this.isDelimiterFollowingFrom(this.linePos)) {
                            this.linePos += this.delimiterFollowingString.length();
                            return quotedValue.toString();
                        }
                    }
                    if (this.isEndOfLine(c)) {
                        this.recordState = RecordState.END;
                        return quotedValue.toString();
                    }
                    if (this.isSpace(c)) continue block8;
                    throw new InvalidCharacterAfterQuoteException(c, this.quote);
                }
                default: {
                    assert (false);
                    continue block8;
                }
            }
        }
    }

    public String nextColumnOrNull() {
        String v = this.nextColumn();
        if (this.nullString == null) {
            if (v.isEmpty()) {
                if (this.wasQuotedColumn) {
                    return "";
                }
                return null;
            }
            return v;
        }
        if (v.equals(this.nullString)) {
            return null;
        }
        return v;
    }

    public boolean wasQuotedColumn() {
        return this.wasQuotedColumn;
    }

    private char nextChar() {
        if (this.line == null) {
            throw new IllegalStateException("nextColumn is called after end of file");
        }
        if (this.linePos >= this.line.length()) {
            return '\u0000';
        }
        return this.line.charAt(this.linePos++);
    }

    private char peekNextChar() {
        if (this.line == null) {
            throw new IllegalStateException("peekNextChar is called after end of file");
        }
        if (this.linePos >= this.line.length()) {
            return '\u0000';
        }
        return this.line.charAt(this.linePos);
    }

    private char peekNextNextChar() {
        if (this.line == null) {
            throw new IllegalStateException("peekNextNextChar is called after end of file");
        }
        if (this.linePos + 1 >= this.line.length()) {
            return '\u0000';
        }
        return this.line.charAt(this.linePos + 1);
    }

    private boolean isSpace(char c) {
        return c == ' ';
    }

    private boolean isDelimiterFollowingFrom(int pos) {
        if (this.line.length() < pos + this.delimiterFollowingString.length()) {
            return false;
        }
        for (int i = 0; i < this.delimiterFollowingString.length(); ++i) {
            if (this.delimiterFollowingString.charAt(i) == this.line.charAt(pos + i)) continue;
            return false;
        }
        return true;
    }

    private boolean isDelimiter(char c) {
        return c == this.delimiterChar;
    }

    private boolean isEndOfLine(char c) {
        return c == '\u0000';
    }

    private boolean isQuote(char c) {
        return this.quote != '\u0000' && c == this.quote;
    }

    private boolean isEscape(char c) {
        return this.escape != '\u0000' && c == this.escape;
    }

    private static String escapeControl(String from) {
        return from.chars().mapToObj(c -> {
            if (c > 32) {
                return "" + (char)c;
            }
            switch (c) {
                case 8: {
                    return "\\b";
                }
                case 10: {
                    return "\\n";
                }
                case 9: {
                    return "\\t";
                }
                case 12: {
                    return "\\f";
                }
                case 13: {
                    return "\\r";
                }
            }
            return String.format("\\u%04x", c);
        }).collect(Collectors.joining());
    }

    private static enum QuotesInQuotedFields {
        ACCEPT_ONLY_RFC4180_ESCAPED,
        ACCEPT_STRAY_QUOTES_ASSUMING_NO_DELIMITERS_IN_FIELDS;

    }

    private static enum ColumnState {
        BEGIN,
        VALUE,
        QUOTED_VALUE,
        AFTER_QUOTED_VALUE,
        FIRST_TRIM,
        LAST_TRIM_OR_VALUE;

    }

    private static enum RecordState {
        NOT_END,
        END;

    }

    public static class Builder {
        private final char delimiterChar;
        private final String delimiterFollowingString;
        private char quote;
        private char escape;
        private String newline;
        private boolean trimIfNotQuoted;
        private QuotesInQuotedFields quotesInQuotedFields;
        private long maxQuotedFieldLength;
        private String commentLineMarker;
        private String nullString;

        private Builder(String delimiter) {
            if (delimiter == null) {
                throw new NullPointerException("CsvTokenizer does not accept null as a delimiter.");
            }
            if (delimiter.isEmpty()) {
                throw new IllegalArgumentException("CsvTokenizer does not accept an empty delimiter.");
            }
            this.delimiterChar = delimiter.charAt(0);
            this.delimiterFollowingString = delimiter.length() > 1 ? delimiter.substring(1) : null;
            this.quote = (char)34;
            this.escape = (char)92;
            this.newline = "\r\n";
            this.trimIfNotQuoted = false;
            this.quotesInQuotedFields = QuotesInQuotedFields.ACCEPT_ONLY_RFC4180_ESCAPED;
            this.maxQuotedFieldLength = 131072L;
            this.commentLineMarker = null;
            this.nullString = null;
        }

        @Deprecated
        public char peekQuote() {
            return this.quote;
        }

        public Builder setQuote(char quote) {
            this.quote = quote;
            return this;
        }

        public Builder noQuote() {
            this.quote = '\u0000';
            return this;
        }

        @Deprecated
        public char peekEscape() {
            return this.escape;
        }

        public Builder setEscape(char escape) {
            this.escape = escape;
            return this;
        }

        public Builder noEscape() {
            this.escape = '\u0000';
            return this;
        }

        @Deprecated
        public String peekNewline() {
            return this.newline;
        }

        public Builder setNewline(String newline) {
            if (newline == null) {
                throw new NullPointerException("CsvTokenizer does not accept null as a newline.");
            }
            if ("\r\n".equals(newline) || "\r".equals(newline) || "\n".equals(newline)) {
                this.newline = newline;
                return this;
            }
            throw new IllegalArgumentException("CsvTokenizer does not accept \"" + CsvTokenizer.escapeControl(newline) + "\" as a newline.");
        }

        @Deprecated
        public boolean isEnabledTrimIfNotQuoted() {
            return this.trimIfNotQuoted;
        }

        public Builder enableTrimIfNotQuoted() {
            this.trimIfNotQuoted = true;
            return this;
        }

        @Deprecated
        public boolean isAcceptingStrayQuotesAssumingNoDelimitersInFields() {
            return this.quotesInQuotedFields == QuotesInQuotedFields.ACCEPT_STRAY_QUOTES_ASSUMING_NO_DELIMITERS_IN_FIELDS;
        }

        public Builder acceptStrayQuotesAssumingNoDelimitersInFields() {
            this.quotesInQuotedFields = QuotesInQuotedFields.ACCEPT_STRAY_QUOTES_ASSUMING_NO_DELIMITERS_IN_FIELDS;
            return this;
        }

        @Deprecated
        public long peekMaxQuotedFieldLength() {
            return this.maxQuotedFieldLength;
        }

        public Builder setMaxQuotedFieldLength(long maxQuotedFieldLength) {
            this.maxQuotedFieldLength = maxQuotedFieldLength;
            return this;
        }

        @Deprecated
        public String peekCommentLineMarker() {
            return this.commentLineMarker;
        }

        public Builder setCommentLineMarker(String commentLineMarker) {
            this.commentLineMarker = commentLineMarker;
            return this;
        }

        @Deprecated
        public String peekNullString() {
            return this.nullString;
        }

        public Builder setNullString(String nullString) {
            this.nullString = nullString;
            return this;
        }

        public CsvTokenizer build(Iterator<String> iterator) {
            if (this.trimIfNotQuoted && this.quotesInQuotedFields != QuotesInQuotedFields.ACCEPT_ONLY_RFC4180_ESCAPED) {
                throw new IllegalStateException("[quotes_in_quoted_fields != ACCEPT_ONLY_RFC4180_ESCAPED] is not allowed to specify with [trim_if_not_quoted = true]");
            }
            return new CsvTokenizer(iterator, this.delimiterChar, this.delimiterFollowingString, this.quote, this.escape, this.newline, this.trimIfNotQuoted, this.quotesInQuotedFields, this.maxQuotedFieldLength, this.commentLineMarker, this.nullString);
        }
    }
}

