/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.dynamic;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.embulk.spi.Column;
import org.embulk.spi.PageBuilder;
import org.embulk.util.dynamic.AbstractDynamicColumnSetter;
import org.embulk.util.dynamic.DefaultValueSetter;
import org.msgpack.value.Value;

public class BooleanColumnSetter
extends AbstractDynamicColumnSetter {
    private static final String[] TRUE_STRINGS_ARRAY = new String[]{"true", "True", "TRUE", "yes", "Yes", "YES", "t", "T", "y", "Y", "on", "On", "ON", "1"};
    private static final Set<String> TRUE_STRINGS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(TRUE_STRINGS_ARRAY)));

    public BooleanColumnSetter(PageBuilder pageBuilder, Column column, DefaultValueSetter defaultValueSetter) {
        super(pageBuilder, column, defaultValueSetter);
    }

    @Override
    public void setNull() {
        this.pageBuilder.setNull(this.column);
    }

    @Override
    public void set(boolean v) {
        this.pageBuilder.setBoolean(this.column, v);
    }

    @Override
    public void set(long v) {
        this.pageBuilder.setBoolean(this.column, v > 0L);
    }

    @Override
    public void set(double v) {
        this.pageBuilder.setBoolean(this.column, v > 0.0);
    }

    @Override
    public void set(String v) {
        if (TRUE_STRINGS.contains(v)) {
            this.pageBuilder.setBoolean(this.column, true);
        } else {
            this.defaultValueSetter.setBoolean(this.pageBuilder, this.column);
        }
    }

    @Override
    public void set(Instant v) {
        this.defaultValueSetter.setBoolean(this.pageBuilder, this.column);
    }

    @Override
    public void set(Value v) {
        this.defaultValueSetter.setBoolean(this.pageBuilder, this.column);
    }
}

