/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.dynamic;

import java.time.Instant;
import org.embulk.spi.Column;
import org.embulk.spi.PageBuilder;
import org.embulk.util.dynamic.AbstractDynamicColumnSetter;
import org.embulk.util.dynamic.DefaultValueSetter;
import org.msgpack.value.Value;

public class DoubleColumnSetter
extends AbstractDynamicColumnSetter {
    public DoubleColumnSetter(PageBuilder pageBuilder, Column column, DefaultValueSetter defaultValueSetter) {
        super(pageBuilder, column, defaultValueSetter);
    }

    @Override
    public void setNull() {
        this.pageBuilder.setNull(this.column);
    }

    @Override
    public void set(boolean v) {
        this.pageBuilder.setDouble(this.column, v ? 1.0 : 0.0);
    }

    @Override
    public void set(long v) {
        this.pageBuilder.setDouble(this.column, (double)v);
    }

    @Override
    public void set(double v) {
        this.pageBuilder.setDouble(this.column, v);
    }

    @Override
    public void set(String v) {
        double dv;
        try {
            dv = Double.parseDouble(v);
        }
        catch (NumberFormatException ex) {
            this.defaultValueSetter.setDouble(this.pageBuilder, this.column);
            return;
        }
        this.pageBuilder.setDouble(this.column, dv);
    }

    @Override
    public void set(Instant v) {
        double sec = v.getEpochSecond();
        double frac = (double)v.getNano() / 1.0E9;
        this.pageBuilder.setDouble(this.column, sec + frac);
    }

    @Override
    public void set(Value v) {
        this.defaultValueSetter.setDouble(this.pageBuilder, this.column);
    }
}

