/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.dynamic;

import java.util.Map;
import org.embulk.config.ConfigException;
import org.embulk.config.ConfigSource;
import org.embulk.spi.Column;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.type.BooleanType;
import org.embulk.spi.type.DoubleType;
import org.embulk.spi.type.JsonType;
import org.embulk.spi.type.LongType;
import org.embulk.spi.type.StringType;
import org.embulk.spi.type.TimestampType;
import org.embulk.spi.type.Type;
import org.embulk.util.dynamic.BooleanColumnSetter;
import org.embulk.util.dynamic.DefaultValueSetter;
import org.embulk.util.dynamic.DoubleColumnSetter;
import org.embulk.util.dynamic.DynamicColumnSetter;
import org.embulk.util.dynamic.JsonColumnSetter;
import org.embulk.util.dynamic.LongColumnSetter;
import org.embulk.util.dynamic.NullDefaultValueSetter;
import org.embulk.util.dynamic.StringColumnSetter;
import org.embulk.util.dynamic.TimestampColumnSetter;
import org.embulk.util.timestamp.TimestampFormatter;

class DynamicColumnSetterFactory {
    private final String defaultZoneString;
    private final Map<String, ConfigSource> columnOptions;
    private final DefaultValueSetter defaultValueSetter;
    private final boolean useColumnForTimestampMetadata;

    private DynamicColumnSetterFactory(String defaultZoneString, Map<String, ConfigSource> columnOptions, DefaultValueSetter defaultValueSetter, boolean useColumnForTimestampMetadata) {
        this.defaultZoneString = defaultZoneString;
        this.columnOptions = columnOptions;
        this.defaultValueSetter = defaultValueSetter;
        this.useColumnForTimestampMetadata = useColumnForTimestampMetadata;
    }

    static DynamicColumnSetterFactory createWithTimestampMetadata(String defaultZoneString, Map<String, ConfigSource> columnOptions, DefaultValueSetter defaultValueSetter) {
        return new DynamicColumnSetterFactory(defaultZoneString, columnOptions, defaultValueSetter, false);
    }

    static DynamicColumnSetterFactory createWithTimestampMetadataFromColumn(String defaultZoneString, Map<String, ConfigSource> columnOptions, DefaultValueSetter defaultValueSetter) {
        return new DynamicColumnSetterFactory(defaultZoneString, columnOptions, defaultValueSetter, true);
    }

    public static DefaultValueSetter nullDefaultValueSetter() {
        return new NullDefaultValueSetter();
    }

    public DynamicColumnSetter newColumnSetter(PageBuilder pageBuilder, Column column) {
        Type type = column.getType();
        if (type instanceof BooleanType) {
            return new BooleanColumnSetter(pageBuilder, column, this.defaultValueSetter);
        }
        if (type instanceof LongType) {
            return new LongColumnSetter(pageBuilder, column, this.defaultValueSetter);
        }
        if (type instanceof DoubleType) {
            return new DoubleColumnSetter(pageBuilder, column, this.defaultValueSetter);
        }
        if (type instanceof StringType) {
            TimestampFormatter formatter = TimestampFormatter.builder((String)this.getTimestampFormatForFormatter(column), (boolean)true).setDefaultZoneFromString(this.getTimeZoneId(column)).build();
            return new StringColumnSetter(pageBuilder, column, this.defaultValueSetter, formatter);
        }
        if (type instanceof TimestampType) {
            TimestampFormatter parser;
            if (this.useColumnForTimestampMetadata) {
                TimestampType timestampType = (TimestampType)type;
                parser = TimestampFormatter.builder((String)this.getFormatFromTimestampTypeWithDepracationSuppressed(timestampType), (boolean)true).setDefaultZoneFromString(this.getTimeZoneId(column)).build();
            } else {
                parser = TimestampFormatter.builder((String)this.getTimestampFormatForParser(column), (boolean)true).setDefaultZoneFromString(this.getTimeZoneId(column)).build();
            }
            return new TimestampColumnSetter(pageBuilder, column, this.defaultValueSetter, parser);
        }
        if (type instanceof JsonType) {
            TimestampFormatter formatter = TimestampFormatter.builder((String)this.getTimestampFormatForFormatter(column), (boolean)true).setDefaultZoneFromString(this.getTimeZoneId(column)).build();
            return new JsonColumnSetter(pageBuilder, column, this.defaultValueSetter, formatter);
        }
        throw new ConfigException("Unknown column type: " + type);
    }

    private String getTimestampFormatForFormatter(Column column) {
        ConfigSource option = this.columnOptions.get(column.getName());
        if (option == null) {
            return "%Y-%m-%d %H:%M:%S.%6N";
        }
        return (String)option.get(String.class, "timestamp_format", (Object)"%Y-%m-%d %H:%M:%S.%6N");
    }

    private String getTimestampFormatForParser(Column column) {
        ConfigSource option = this.columnOptions.get(column.getName());
        if (option == null) {
            return "%Y-%m-%d %H:%M:%S.%N";
        }
        return (String)option.get(String.class, "timestamp_format", (Object)"%Y-%m-%d %H:%M:%S.%N");
    }

    private String getTimeZoneId(Column column) {
        ConfigSource option = this.columnOptions.get(column.getName());
        if (option == null) {
            return this.defaultZoneString;
        }
        return (String)option.get(String.class, "timezone", (Object)this.defaultZoneString);
    }

    private String getFormatFromTimestampTypeWithDepracationSuppressed(TimestampType timestampType) {
        return timestampType.getFormat();
    }
}

