/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.dynamic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.embulk.config.ConfigSource;
import org.embulk.spi.BufferAllocator;
import org.embulk.spi.Column;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.PageOutput;
import org.embulk.spi.Schema;
import org.embulk.util.dynamic.DynamicColumnNotFoundException;
import org.embulk.util.dynamic.DynamicColumnSetter;
import org.embulk.util.dynamic.DynamicColumnSetterFactory;
import org.embulk.util.dynamic.SkipColumnSetter;

public class DynamicPageBuilder
implements AutoCloseable {
    private final PageBuilder pageBuilder;
    private final Schema schema;
    private final DynamicColumnSetter[] setters;
    private final Map<String, DynamicColumnSetter> columnLookup;

    private DynamicPageBuilder(DynamicColumnSetterFactory factory, BufferAllocator allocator, PageBuilder pageBuilder, Schema schema, PageOutput output) {
        this.pageBuilder = pageBuilder;
        this.schema = schema;
        ArrayList<DynamicColumnSetter> setters = new ArrayList<DynamicColumnSetter>();
        LinkedHashMap<String, DynamicColumnSetter> lookup = new LinkedHashMap<String, DynamicColumnSetter>();
        for (Column c : schema.getColumns()) {
            DynamicColumnSetter setter = factory.newColumnSetter(this.pageBuilder, c);
            setters.add(setter);
            lookup.put(c.getName(), setter);
        }
        this.setters = setters.toArray(new DynamicColumnSetter[0]);
        this.columnLookup = Collections.unmodifiableMap(lookup);
    }

    public static DynamicPageBuilder createWithTimestampMetadata(String defaultZoneString, Map<String, ConfigSource> columnOptions, BufferAllocator allocator, PageBuilder pageBuilder, Schema schema, PageOutput output) {
        DynamicColumnSetterFactory factory = DynamicColumnSetterFactory.createWithTimestampMetadata(defaultZoneString, columnOptions, DynamicColumnSetterFactory.nullDefaultValueSetter());
        return new DynamicPageBuilder(factory, allocator, pageBuilder, schema, output);
    }

    public static DynamicPageBuilder createWithTimestampMetadataFromColumn(String defaultZoneString, Map<String, ConfigSource> columnOptions, BufferAllocator allocator, PageBuilder pageBuilder, Schema schema, PageOutput output) {
        DynamicColumnSetterFactory factory = DynamicColumnSetterFactory.createWithTimestampMetadataFromColumn(defaultZoneString, columnOptions, DynamicColumnSetterFactory.nullDefaultValueSetter());
        return new DynamicPageBuilder(factory, allocator, pageBuilder, schema, output);
    }

    public List<Column> getColumns() {
        return this.schema.getColumns();
    }

    public DynamicColumnSetter column(Column c) {
        return this.setters[c.getIndex()];
    }

    public DynamicColumnSetter column(int index) {
        if (index < 0 || this.setters.length <= index) {
            throw new DynamicColumnNotFoundException("Column index '" + index + "' is not exist");
        }
        return this.setters[index];
    }

    public DynamicColumnSetter lookupColumn(String columnName) {
        DynamicColumnSetter setter = this.columnLookup.get(columnName);
        if (setter == null) {
            throw new DynamicColumnNotFoundException("Column '" + columnName + "' is not exist");
        }
        return setter;
    }

    public DynamicColumnSetter columnOrSkip(int index) {
        if (index < 0 || this.setters.length <= index) {
            return SkipColumnSetter.get();
        }
        return this.setters[index];
    }

    public DynamicColumnSetter columnOrSkip(String columnName) {
        DynamicColumnSetter setter = this.columnLookup.get(columnName);
        if (setter == null) {
            return SkipColumnSetter.get();
        }
        return setter;
    }

    protected DynamicColumnSetter columnOrNull(int index) {
        if (index < 0 || this.setters.length <= index) {
            return null;
        }
        return this.setters[index];
    }

    protected DynamicColumnSetter columnOrNull(String columnName) {
        return this.columnLookup.get(columnName);
    }

    public void addRecord() {
        this.pageBuilder.addRecord();
    }

    public void flush() {
        this.pageBuilder.flush();
    }

    public void finish() {
        this.pageBuilder.finish();
    }

    @Override
    public void close() {
        this.pageBuilder.close();
    }
}

