/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.dynamic;

import java.time.Instant;
import org.embulk.spi.Column;
import org.embulk.spi.PageBuilder;
import org.embulk.util.dynamic.AbstractDynamicColumnSetter;
import org.embulk.util.dynamic.DefaultValueSetter;
import org.embulk.util.timestamp.TimestampFormatter;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class JsonColumnSetter
extends AbstractDynamicColumnSetter {
    private final TimestampFormatter timestampFormatter;

    public JsonColumnSetter(PageBuilder pageBuilder, Column column, DefaultValueSetter defaultValueSetter, TimestampFormatter timestampFormatter) {
        super(pageBuilder, column, defaultValueSetter);
        this.timestampFormatter = timestampFormatter;
    }

    @Override
    public void setNull() {
        this.pageBuilder.setNull(this.column);
    }

    @Override
    public void set(boolean v) {
        this.pageBuilder.setJson(this.column, (Value)ValueFactory.newBoolean((boolean)v));
    }

    @Override
    public void set(long v) {
        this.pageBuilder.setJson(this.column, (Value)ValueFactory.newInteger((long)v));
    }

    @Override
    public void set(double v) {
        this.pageBuilder.setJson(this.column, (Value)ValueFactory.newFloat((double)v));
    }

    @Override
    public void set(String v) {
        this.pageBuilder.setJson(this.column, (Value)ValueFactory.newString((String)v));
    }

    @Override
    public void set(Instant v) {
        this.pageBuilder.setJson(this.column, (Value)ValueFactory.newString((String)this.timestampFormatter.format(v)));
    }

    @Override
    public void set(Value v) {
        this.pageBuilder.setJson(this.column, v);
    }
}

