/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.dynamic;

import java.time.Instant;
import java.time.format.DateTimeParseException;
import org.embulk.spi.Column;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.time.Timestamp;
import org.embulk.util.dynamic.AbstractDynamicColumnSetter;
import org.embulk.util.dynamic.DefaultValueSetter;
import org.embulk.util.timestamp.TimestampFormatter;
import org.msgpack.value.Value;

public class TimestampColumnSetter
extends AbstractDynamicColumnSetter {
    private static final boolean HAS_SET_TIMESTAMP_INSTANT = TimestampColumnSetter.hasSetTimestampInstant();
    private static final boolean HAS_SET_TIMESTAMP_TIMESTAMP = TimestampColumnSetter.hasSetTimestampTimestamp();
    private final TimestampFormatter timestampParser;

    public TimestampColumnSetter(PageBuilder pageBuilder, Column column, DefaultValueSetter defaultValueSetter, TimestampFormatter timestampParser) {
        super(pageBuilder, column, defaultValueSetter);
        this.timestampParser = timestampParser;
    }

    @Override
    public void setNull() {
        this.pageBuilder.setNull(this.column);
    }

    @Override
    public void set(boolean v) {
        this.defaultValueSetter.setTimestamp(this.pageBuilder, this.column);
    }

    @Override
    public void set(long v) {
        if (HAS_SET_TIMESTAMP_INSTANT) {
            this.pageBuilder.setTimestamp(this.column, Instant.ofEpochSecond(v));
        } else if (HAS_SET_TIMESTAMP_TIMESTAMP) {
            this.pageBuilder.setTimestamp(this.column, Timestamp.ofEpochSecond((long)v));
        } else {
            throw new IllegalStateException("Neither PageBuilder#setTimestamp(Column, Instant) nor PageBuilder#setTimestamp(Column, Timestamp) found.");
        }
    }

    @Override
    public void set(double v) {
        long sec = (long)v;
        int nsec = (int)((v - (double)sec) * 1.0E9);
        if (HAS_SET_TIMESTAMP_INSTANT) {
            this.pageBuilder.setTimestamp(this.column, Instant.ofEpochSecond(sec, nsec));
        } else if (HAS_SET_TIMESTAMP_TIMESTAMP) {
            this.pageBuilder.setTimestamp(this.column, Timestamp.ofEpochSecond((long)sec, (long)nsec));
        }
        this.defaultValueSetter.setTimestamp(this.pageBuilder, this.column);
    }

    @Override
    public void set(String v) {
        Instant parsed;
        try {
            parsed = this.timestampParser.parse(v);
        }
        catch (DateTimeParseException ex) {
            this.defaultValueSetter.setTimestamp(this.pageBuilder, this.column);
            return;
        }
        if (HAS_SET_TIMESTAMP_INSTANT) {
            this.pageBuilder.setTimestamp(this.column, parsed);
        } else if (HAS_SET_TIMESTAMP_TIMESTAMP) {
            this.pageBuilder.setTimestamp(this.column, Timestamp.ofInstant((Instant)parsed));
        } else {
            throw new IllegalStateException("Neither PageBuilder#setTimestamp(Column, Instant) nor PageBuilder#setTimestamp(Column, Timestamp) found.");
        }
    }

    @Override
    public void set(Instant v) {
        if (HAS_SET_TIMESTAMP_INSTANT) {
            this.pageBuilder.setTimestamp(this.column, v);
        } else if (HAS_SET_TIMESTAMP_TIMESTAMP) {
            this.pageBuilder.setTimestamp(this.column, Timestamp.ofInstant((Instant)v));
        } else {
            throw new IllegalStateException("Neither PageBuilder#setTimestamp(Column, Instant) nor PageBuilder#setTimestamp(Column, Timestamp) found.");
        }
    }

    @Override
    public void set(Value v) {
        this.defaultValueSetter.setTimestamp(this.pageBuilder, this.column);
    }

    private static boolean hasSetTimestampTimestamp() {
        try {
            PageBuilder.class.getMethod("setTimestamp", Column.class, Timestamp.class);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        return true;
    }

    private static boolean hasSetTimestampInstant() {
        try {
            PageBuilder.class.getMethod("setTimestamp", Column.class, Instant.class);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        return true;
    }
}

