/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.file;

import java.io.InputStream;
import org.embulk.spi.Buffer;
import org.embulk.spi.FileInput;
import org.embulk.util.file.EmptyBuffer;

public class FileInputInputStream
extends InputStream {
    private int pos = 0;
    private Buffer buffer = EmptyBuffer.INSTANCE;
    private final FileInput in;

    public FileInputInputStream(FileInput in) {
        this.in = in;
    }

    public boolean nextFile() {
        this.releaseBuffer();
        return this.in.nextFile();
    }

    @Override
    public int read() {
        while (this.pos >= this.buffer.limit()) {
            if (this.nextBuffer()) continue;
            return -1;
        }
        byte b = this.buffer.array()[this.buffer.offset() + this.pos];
        ++this.pos;
        if (this.pos >= this.buffer.limit()) {
            this.releaseBuffer();
        }
        return b & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int lengthToRead;
        boolean allConsumed;
        while (this.pos >= this.buffer.limit()) {
            if (this.nextBuffer()) continue;
            return -1;
        }
        int remaining = this.buffer.limit() - this.pos;
        if (remaining <= len) {
            allConsumed = true;
            lengthToRead = remaining;
        } else {
            allConsumed = false;
            lengthToRead = len;
        }
        if (b != null) {
            this.buffer.getBytes(this.pos, b, off, lengthToRead);
        }
        if (allConsumed) {
            this.releaseBuffer();
        } else {
            this.pos += lengthToRead;
        }
        return lengthToRead;
    }

    @Override
    public long skip(long len) {
        int skipped = this.read(null, 0, (int)Math.min(len, Integer.MAX_VALUE));
        return skipped > 0 ? (long)skipped : 0L;
    }

    @Override
    public int available() {
        return this.buffer.limit() - this.pos;
    }

    @Override
    public void close() {
        this.releaseBuffer();
        this.in.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private boolean nextBuffer() {
        this.releaseBuffer();
        Buffer b = this.in.poll();
        if (b == null) {
            return false;
        }
        this.buffer = b;
        return true;
    }

    private void releaseBuffer() {
        this.buffer.release();
        this.buffer = EmptyBuffer.INSTANCE;
        this.pos = 0;
    }
}

