/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.file;

import java.util.Iterator;
import org.embulk.spi.Buffer;
import org.embulk.spi.FileInput;

public class ListFileInput
implements FileInput {
    private Iterator<Buffer> currentBuffers;
    private final Iterator<? extends Iterable<Buffer>> files;

    public ListFileInput(Iterable<? extends Iterable<Buffer>> files) {
        this.files = files.iterator();
    }

    public boolean nextFile() {
        if (!this.files.hasNext()) {
            return false;
        }
        this.currentBuffers = this.files.next().iterator();
        return true;
    }

    public Buffer poll() {
        if (this.currentBuffers == null) {
            throw new IllegalStateException("FileInput#nextFile() is not called.");
        }
        if (!this.currentBuffers.hasNext()) {
            return null;
        }
        return this.currentBuffers.next();
    }

    public void close() {
        while (true) {
            Buffer b;
            if ((b = this.poll()) != null) {
                b.release();
                continue;
            }
            if (!this.nextFile()) break;
        }
    }
}

