/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.file;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import org.embulk.spi.Buffer;
import org.embulk.spi.FileOutput;

public class OutputStreamFileOutput
implements FileOutput {
    private OutputStream current = null;
    private final Provider provider;

    public OutputStreamFileOutput(Provider provider) {
        this.provider = provider;
    }

    public void nextFile() {
        this.closeCurrent();
        try {
            this.current = this.provider.openNext();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void add(Buffer buffer) {
        if (this.current == null) {
            throw new IllegalStateException("OutputStreamFileOutput#nextFile() must be called before poll().");
        }
        try {
            this.current.write(buffer.array(), buffer.offset(), buffer.limit());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        finally {
            buffer.release();
        }
    }

    public void finish() {
        this.closeCurrent();
        try {
            this.provider.finish();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void close() {
        try {
            this.closeCurrent();
        }
        finally {
            try {
                this.provider.close();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    private void closeCurrent() {
        try {
            if (this.current != null) {
                this.current.close();
                this.current = null;
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static interface Provider
    extends Closeable {
        public OutputStream openNext() throws IOException;

        public void finish() throws IOException;

        @Override
        public void close() throws IOException;
    }
}

