/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

public class ResumableInputStream
extends InputStream {
    protected InputStream in;
    private long offset;
    private long markedOffset;
    private Exception lastClosedCause;
    private boolean closed;
    private final Reopener reopener;

    public ResumableInputStream(InputStream initialInputStream, Reopener reopener) {
        this.in = initialInputStream;
        this.offset = 0L;
        this.markedOffset = 0L;
        this.lastClosedCause = null;
        this.closed = false;
        this.reopener = reopener;
    }

    public ResumableInputStream(Reopener reopener) throws IOException {
        this(reopener.reopen(0L, null), reopener);
    }

    @Override
    public int read() throws IOException {
        this.ensureOpened();
        while (true) {
            try {
                int v = this.in.read();
                ++this.offset;
                return v;
            }
            catch (IOException | RuntimeException ex) {
                this.reopen(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.ensureOpened();
        while (true) {
            try {
                int r = this.in.read(b);
                this.offset += (long)r;
                return r;
            }
            catch (IOException | RuntimeException ex) {
                this.reopen(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpened();
        while (true) {
            try {
                int r = this.in.read(b, off, len);
                this.offset += (long)r;
                return r;
            }
            catch (IOException | RuntimeException ex) {
                this.reopen(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpened();
        while (true) {
            try {
                long r = this.in.skip(n);
                this.offset += r;
                return r;
            }
            catch (IOException | RuntimeException ex) {
                this.reopen(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public int available() throws IOException {
        this.ensureOpened();
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.closed = true;
            this.in = null;
        }
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.ensureOpened();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        this.in.mark(readlimit);
        this.markedOffset = this.offset;
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpened();
        this.in.reset();
        this.offset = this.markedOffset;
    }

    @Override
    public boolean markSupported() {
        try {
            this.ensureOpened();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return this.in.markSupported();
    }

    private void reopen(Exception closedCause) throws IOException {
        if (this.in != null) {
            this.lastClosedCause = closedCause;
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.in = null;
        }
        this.in = this.reopener.reopen(this.offset, closedCause);
        this.lastClosedCause = null;
    }

    private void ensureOpened() throws IOException {
        if (this.in == null) {
            if (this.closed) {
                throw new IOException("InputStream in ResumableInputStream is unexpectedly closed.");
            }
            this.reopen(this.lastClosedCause);
        }
    }

    public static interface Reopener {
        public InputStream reopen(long var1, Exception var3) throws IOException;
    }
}

