/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.guess.timeformat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import org.embulk.util.guess.timeformat.GuessOption;
import org.embulk.util.guess.timeformat.GuessPart;
import org.embulk.util.guess.timeformat.TimeFormatMatch;

final class GuessMatch
implements TimeFormatMatch {
    private static final List<GuessPart> DMY_SEQUENCE = Arrays.asList(GuessPart.DAY, GuessPart.MONTH, GuessPart.YEAR);
    private static final List<GuessPart> MDY_SEQUENCE = Arrays.asList(GuessPart.MONTH, GuessPart.DAY, GuessPart.YEAR);
    private final List<String> delimiters;
    private final ArrayList<GuessPart> parts;
    private final ArrayList<GuessOption> partOptions;

    GuessMatch(List<String> delimiters, List<GuessPart> parts, List<GuessOption> partOptions) {
        this.delimiters = Collections.unmodifiableList(new ArrayList<String>(delimiters));
        this.parts = new ArrayList<GuessPart>(parts);
        this.partOptions = new ArrayList<GuessOption>(partOptions);
    }

    @Override
    public String getFormat() {
        StringBuilder format = new StringBuilder();
        block32: for (int i = 0; i < this.parts.size(); ++i) {
            if (i != 0) {
                format.append(this.delimiters.get(i - 1));
            }
            GuessOption option = this.partOptions.get(i);
            switch (this.parts.get(i)) {
                case YEAR: {
                    format.append("%Y");
                    continue block32;
                }
                case MONTH: {
                    switch (option) {
                        case ZERO: {
                            format.append("%m");
                            continue block32;
                        }
                        case BLANK: {
                            format.append("%m");
                            continue block32;
                        }
                        case NONE: {
                            format.append("%m");
                            continue block32;
                        }
                    }
                    format.append("%m");
                    continue block32;
                }
                case DAY: {
                    switch (option) {
                        case ZERO: {
                            format.append("%d");
                            continue block32;
                        }
                        case BLANK: {
                            format.append("%e");
                            continue block32;
                        }
                        case NONE: {
                            format.append("%d");
                            continue block32;
                        }
                    }
                    format.append("%d");
                    continue block32;
                }
                case HOUR: {
                    switch (option) {
                        case ZERO: {
                            format.append("%H");
                            continue block32;
                        }
                        case BLANK: {
                            format.append("%k");
                            continue block32;
                        }
                        case NONE: {
                            format.append("%k");
                            continue block32;
                        }
                    }
                    format.append("%H");
                    continue block32;
                }
                case MINUTE: {
                    format.append("%M");
                    continue block32;
                }
                case SECOND: {
                    format.append("%S");
                    continue block32;
                }
                case FRAC: {
                    switch (option) {
                        case FRAC_3: {
                            format.append("%L");
                            continue block32;
                        }
                        case FRAC_N: {
                            format.append("%N");
                            continue block32;
                        }
                    }
                    format.append("%N");
                    continue block32;
                }
                case ZONE: {
                    switch (option) {
                        case EXTENDED: {
                            format.append("%:z");
                            continue block32;
                        }
                    }
                    format.append("%z");
                    continue block32;
                }
                default: {
                    throw new RuntimeException("Unknown part: #{@parts[i]}");
                }
            }
        }
        return format.toString();
    }

    @Override
    public String getIdentifier() {
        OptionalInt i = GuessMatch.findSubsequence(this.parts, DMY_SEQUENCE);
        if (i.isPresent()) {
            int index = i.getAsInt();
            ArrayList<GuessPart> ps = new ArrayList<GuessPart>(this.parts);
            ps.set(index, GuessPart.MONTH);
            ps.set(index + 1, GuessPart.DAY);
            ps.set(index + 2, GuessPart.YEAR);
            return GuessMatch.buildIdentifier(this.delimiters, Collections.unmodifiableList(ps));
        }
        return GuessMatch.buildIdentifier(this.delimiters, this.parts);
    }

    @Override
    public void mergeFrom(TimeFormatMatch anotherInGroup) {
        if (!(anotherInGroup instanceof GuessMatch)) {
            return;
        }
        GuessMatch another = (GuessMatch)anotherInGroup;
        List<GuessOption> anotherPartOptions = another.getPartOptions();
        for (int i = 0; i < this.partOptions.size(); ++i) {
            if (this.partOptions.get(i) != null) continue;
            this.partOptions.set(i, anotherPartOptions.get(i));
        }
        OptionalInt dmy = GuessMatch.findSubsequence(another.getParts(), DMY_SEQUENCE);
        OptionalInt mdy = GuessMatch.findSubsequence(this.parts, MDY_SEQUENCE);
        if (mdy.isPresent() && dmy.isPresent()) {
            int index = mdy.getAsInt();
            this.parts.set(index, GuessPart.DAY);
            this.parts.set(index + 1, GuessPart.MONTH);
            this.parts.set(index + 2, GuessPart.YEAR);
        }
    }

    List<GuessPart> getParts() {
        return this.parts;
    }

    List<GuessOption> getPartOptions() {
        return this.partOptions;
    }

    public String toString() {
        return GuessMatch.buildIdentifier(this.delimiters, this.parts);
    }

    private static OptionalInt findSubsequence(List<GuessPart> entire, List<GuessPart> target) {
        for (int i = 0; i < entire.size() - target.size() + 1; ++i) {
            if (!entire.subList(i, i + target.size()).equals(target)) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private static String buildIdentifier(List<String> delimiters, List<GuessPart> parts) {
        StringBuilder builder = new StringBuilder();
        for (GuessPart part : parts) {
            builder.append("$");
            builder.append(part.toString());
        }
        for (String delimiter : delimiters) {
            builder.append("@");
            builder.append(delimiter.toString());
        }
        return String.format("GuessMatch[%s]", builder.toString());
    }
}

