/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.guess.timeformat;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.embulk.util.guess.timeformat.SimpleMatch;
import org.embulk.util.guess.timeformat.TimeFormatMatch;
import org.embulk.util.guess.timeformat.TimeFormatPattern;

final class Rfc2822Pattern
implements TimeFormatPattern {
    private static final Pattern REGEX = Pattern.compile(String.format("^(?<weekday>%s, )?\\d\\d %s \\d\\d\\d\\d(?<time> \\d\\d:\\d\\d(?<second>:\\d\\d)? (?:(?<zoneOff>%s)|(?<zoneAbb>%s)))?$", "(Sun|Mon|Tue|Wed|Thu|Fri|Sat)", "(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)", "(?:Z|[\\-\\+]\\d\\d(?::?\\d\\d)?)", "([A-Z]{1,3})"));

    Rfc2822Pattern() {
    }

    @Override
    public TimeFormatMatch match(String text) {
        Matcher matcher = REGEX.matcher(text);
        if (matcher.matches()) {
            StringBuilder format = new StringBuilder();
            if (matcher.group("weekday") != null && !matcher.group("weekday").isEmpty()) {
                format.append("%a, ");
            }
            format.append("%d %b %Y");
            if (matcher.group("time") != null && !matcher.group("time").isEmpty()) {
                format.append(" %H:%M");
            }
            if (matcher.group("second") != null && !matcher.group("second").isEmpty()) {
                format.append(":%S");
            }
            if (matcher.group("zoneOff") != null && !matcher.group("zoneOff").isEmpty()) {
                if (matcher.group("zoneOff").contains(":")) {
                    format.append(" %:z");
                } else {
                    format.append(" %z");
                }
            } else if (matcher.group("zoneAbb") != null && !matcher.group("zoneAbb").isEmpty()) {
                format.append(" %z");
            }
            return new SimpleMatch(format.toString());
        }
        return null;
    }
}

