/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.guess;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.embulk.config.ConfigDiff;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.guess.GuesstimatedType;
import org.embulk.util.guess.TimeFormatGuess;

public final class SchemaGuess {
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("^[+-]?(NaN|Infinity|([1-9]\\d*|0)(\\.\\d+)([eE][+-]?\\d+)?[fFdD]?)$");
    private static final String[] TRUE_STRINGS_ARRAY = new String[]{"true", "True", "TRUE", "yes", "Yes", "YES", "t", "T", "y", "Y", "on", "On", "ON"};
    private static final String[] FALSE_STRINGS_ARRAY = new String[]{"false", "False", "FALSE", "no", "No", "NO", "f", "F", "n", "N", "off", "Off", "OFF"};
    private static final Set<String> TRUE_STRINGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(TRUE_STRINGS_ARRAY)));
    private static final Set<String> FALSE_STRINGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(FALSE_STRINGS_ARRAY)));
    private final ConfigMapperFactory configMapperFactory;
    private final TimeFormatGuess timeFormatGuess;

    private SchemaGuess(ConfigMapperFactory configMapperFactory, TimeFormatGuess timeFormatGuess) {
        this.configMapperFactory = configMapperFactory;
        this.timeFormatGuess = timeFormatGuess;
    }

    public static SchemaGuess of(ConfigMapperFactory configMapperFactory) {
        return new SchemaGuess(configMapperFactory, TimeFormatGuess.of());
    }

    public List<ConfigDiff> fromLinkedHashMapRecords(List<LinkedHashMap<String, Object>> listOfMap) {
        if (listOfMap.isEmpty()) {
            throw new RuntimeException("SchemaGuess cannot guess Schema from no records.");
        }
        List<String> columnNames = Collections.unmodifiableList(new ArrayList<String>(listOfMap.get(0).keySet()));
        ArrayList samples = new ArrayList();
        for (LinkedHashMap<String, Object> map : listOfMap) {
            ArrayList<Object> record = new ArrayList<Object>();
            for (String name : columnNames) {
                record.add(map.get(name));
            }
            samples.add(Collections.unmodifiableList(record));
        }
        return this.fromListRecords(columnNames, Collections.unmodifiableList(samples));
    }

    public List<ConfigDiff> fromListRecords(List<String> columnNames, List<List<Object>> samples) {
        List<GuesstimatedType> columnTypes = this.typesFromListRecords(samples);
        if (columnNames.size() != columnTypes.size()) {
            throw new IllegalArgumentException("The number of column names are different from actual sample data.");
        }
        ArrayList<ConfigDiff> columns = new ArrayList<ConfigDiff>();
        int size = columnNames.size();
        for (int i = 0; i < size; ++i) {
            GuesstimatedType type = columnTypes.get(i);
            String name = columnNames.get(i);
            ConfigDiff column = this.configMapperFactory.newConfigDiff();
            column.set("index", (Object)i);
            column.set("name", (Object)name);
            column.set("type", (Object)type.toString());
            if (type.isTimestamp()) {
                column.set("format", (Object)type.getFormatOrTimeValue());
            }
            columns.add(column);
        }
        return Collections.unmodifiableList(columns);
    }

    public List<GuesstimatedType> typesFromListRecords(List<List<Object>> samples) {
        int maxRecords = samples.stream().mapToInt(List::size).max().orElse(0);
        if (maxRecords <= 0) {
            return Collections.emptyList();
        }
        ArrayList columnarTypes = new ArrayList(maxRecords);
        for (int i = 0; i < maxRecords; ++i) {
            columnarTypes.add(new ArrayList());
        }
        for (List<Object> record : samples) {
            for (int i = 0; i < record.size(); ++i) {
                Object value = record.get(i);
                ((ArrayList)columnarTypes.get(i)).add(this.guessType(value));
            }
        }
        return columnarTypes.stream().map(types -> this.mergeTypes((List<GuesstimatedType>)types)).collect(Collectors.toList());
    }

    private GuesstimatedType guessType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map || value instanceof List) {
            return GuesstimatedType.JSON;
        }
        String str = value.toString();
        if (TRUE_STRINGS.contains(str) || FALSE_STRINGS.contains(str)) {
            return GuesstimatedType.BOOLEAN;
        }
        if (this.timeFormatGuess.guess(Arrays.asList(str)) != null) {
            return GuesstimatedType.timestamp(str);
        }
        try {
            if (Long.valueOf(str).toString().equals(str)) {
                return GuesstimatedType.LONG;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (DOUBLE_PATTERN.matcher(str).matches()) {
            return GuesstimatedType.DOUBLE;
        }
        if (str.isEmpty()) {
            return null;
        }
        try {
            JsonNode node = new ObjectMapper().readTree(str);
            if (node.isContainerNode()) {
                return GuesstimatedType.JSON;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return GuesstimatedType.STRING;
    }

    private GuesstimatedType mergeTypes(List<GuesstimatedType> types) {
        GuesstimatedType t = Optional.ofNullable(types.stream().reduce(null, (merged, type) -> SchemaGuess.mergeType(merged, type))).orElse(GuesstimatedType.STRING);
        if (t.isTimestamp()) {
            String format = this.timeFormatGuess.guess(types.stream().map(type -> type != null && type.isTimestamp() ? type.getFormatOrTimeValue() : null).filter(type -> type != null).collect(Collectors.toList()));
            return GuesstimatedType.timestamp(format);
        }
        return t;
    }

    private static GuesstimatedType mergeType(GuesstimatedType type1, GuesstimatedType type2) {
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        if (type1.typeEquals(type2)) {
            return type1;
        }
        return SchemaGuess.coalesceType(type1, type2);
    }

    private static GuesstimatedType coalesceType(GuesstimatedType type1, GuesstimatedType type2) {
        Object[] types = new GuesstimatedType[]{type1, type2};
        Arrays.sort(types);
        if (types[0] == GuesstimatedType.DOUBLE && types[1] == GuesstimatedType.LONG) {
            return GuesstimatedType.DOUBLE;
        }
        if (types[0] == GuesstimatedType.BOOLEAN && types[1] == GuesstimatedType.LONG) {
            return GuesstimatedType.LONG;
        }
        if (types[0] == GuesstimatedType.LONG && ((GuesstimatedType)types[1]).isTimestamp()) {
            return GuesstimatedType.LONG;
        }
        return GuesstimatedType.STRING;
    }
}

