/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.guess.timeformat;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class GuessTimePicker {
    private static final String DATE_TIME_DELIMS = "(:? |\\_|T|\\. ?)";
    private static final String TIME_DELIMS = "[\\:\\-]";
    private static final String FRAC_DELIMS = "[\\.\\,]";
    private static final String FRAC = "[0-9]{1,9}";
    private static final String TIME = String.format("(?<hour>%s)(?:(?<timeDelim>%s)(?<minute>%s)(?:\\k<timeDelim>(?<second>%s)(?:(?<fracDelim>%s)(?<frac>%s))?)?)?", "20|21|22|23|24|1[0-9]|[0 ]?[0-9]", "[\\:\\-]", "60|[1-5][0-9]|[0 ]?[0-9]", "60|[1-5][0-9]|[0 ]?[0-9]", "[\\.\\,]", "[0-9]{1,9}");
    private static final String TIME_NODELIM = String.format("(?<hour>%s)(?:(?<minute>%s)((?<second>%s)(?:(?<fracDelim>%s)(?<frac>%s))?)?)?", "20|21|22|23|24|1[0-9]|[0][0-9]", "60|[1-5][0-9]|[0][0-9]", "60|[1-5][0-9]|[0][0-9]", "[\\.\\,]", "[0-9]{1,9}");
    private static final Pattern TIME_DELIM_WITH_DATE_TIME_DELIM = Pattern.compile(String.format("^(?<dateTimeDelim>%s)%s(?<rest>.*?)?$", "(:? |\\_|T|\\. ?)", TIME));
    private static final Pattern TIME_NODELIM_WITH_DATE_TIME_DELIM = Pattern.compile(String.format("^(?<dateTimeDelim>%s)%s(?<rest>.*?)?$", "(:? |\\_|T|\\. ?)", TIME_NODELIM));
    private static final Pattern TIME_NODELIM_WITH_DATE_TIME_NODELIM = Pattern.compile(String.format("^%s(?<rest>.*?)?$", TIME_NODELIM));
    private static TimeMatcher[] TIME_MATCHERS = new TimeMatcher[]{new TimeMatcher(TIME_DELIM_WITH_DATE_TIME_DELIM, false, true, true), new TimeMatcher(TIME_NODELIM_WITH_DATE_TIME_DELIM, false, false, true), new TimeMatcher(TIME_NODELIM_WITH_DATE_TIME_NODELIM, true, false, false)};
    private final String dateTimeDelim;
    private final String timeDelim;
    private final String fracDelim;
    private final String hour;
    private final String minute;
    private final String second;
    private final String frac;
    private final String rest;

    private GuessTimePicker(String dateTimeDelim, String timeDelim, String fracDelim, String hour, String minute, String second, String frac, String rest) {
        this.dateTimeDelim = dateTimeDelim;
        this.timeDelim = timeDelim;
        this.fracDelim = fracDelim;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.frac = frac;
        this.rest = rest;
    }

    static GuessTimePicker from(String text, String dateDelim) {
        for (TimeMatcher matcher : TIME_MATCHERS) {
            GuessTimePicker matched = matcher.match(text, dateDelim);
            if (matched == null) continue;
            return matched;
        }
        return null;
    }

    String getDateTimeDelim() {
        return this.dateTimeDelim;
    }

    String getTimeDelim() {
        return this.timeDelim;
    }

    String getFracDelim() {
        return this.fracDelim;
    }

    String getHour() {
        return this.hour;
    }

    String getMinute() {
        return this.minute;
    }

    String getSecond() {
        return this.second;
    }

    String getFrac() {
        return this.frac;
    }

    String getRest() {
        return this.rest;
    }

    private static class TimeMatcher {
        private final Pattern pattern;
        private final boolean requireDateDelimEmpty;
        private final boolean hasTimeDelim;
        private final boolean hasDateTimeDelim;

        TimeMatcher(Pattern pattern, boolean requireDateDelimEmpty, boolean hasTimeDelim, boolean hasDateTimeDelim) {
            this.pattern = pattern;
            this.requireDateDelimEmpty = requireDateDelimEmpty;
            this.hasTimeDelim = hasTimeDelim;
            this.hasDateTimeDelim = hasDateTimeDelim;
        }

        GuessTimePicker match(String text, String dateDelim) {
            if (this.requireDateDelimEmpty && !dateDelim.isEmpty()) {
                return null;
            }
            Matcher matcher = this.pattern.matcher(text);
            if (matcher.matches()) {
                String dateTimeDelim = this.hasDateTimeDelim ? matcher.group("dateTimeDelim") : "";
                String timeDelim = this.hasTimeDelim ? matcher.group("timeDelim") : "";
                String fracDelim = matcher.group("fracDelim");
                String hour = matcher.group("hour");
                String minute = matcher.group("minute");
                String second = matcher.group("second");
                String frac = matcher.group("frac");
                String rest = matcher.group("rest");
                return new GuessTimePicker(dateTimeDelim != null ? dateTimeDelim : "", timeDelim != null ? timeDelim : "", fracDelim != null ? fracDelim : "", hour != null ? hour : "", minute != null ? minute : "", second != null ? second : "", frac != null ? frac : "", rest != null ? rest : "");
            }
            return null;
        }

        public String toString() {
            return this.pattern.toString();
        }
    }
}

