/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.guess;

import java.nio.charset.Charset;
import org.embulk.config.ConfigSource;
import org.embulk.spi.Buffer;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.guess.CharsetGuess;
import org.embulk.util.text.LineDelimiter;
import org.embulk.util.text.Newline;

final class GuessUtil {
    private GuessUtil() {
    }

    static Charset getCharset(ConfigSource parserConfig, ConfigMapperFactory configMapperFactory, Buffer sample) {
        String charsetString = parserConfig.has("charset") ? (String)parserConfig.get(String.class, "charset", (Object)"utf-8") : (String)CharsetGuess.of(configMapperFactory).guess(sample).getNestedOrGetEmpty("parser").get(String.class, "charset", (Object)"utf-8");
        return Charset.forName(charsetString);
    }

    static LineDelimiter getLineDelimiter(ConfigSource parserConfig) {
        String lineDelimiterString = (String)parserConfig.get(String.class, "line_delimiter_recognized", null);
        if (lineDelimiterString == null) {
            return null;
        }
        return (LineDelimiter)LineDelimiter.valueOf(LineDelimiter.class, (String)lineDelimiterString);
    }

    static Newline getNewline(ConfigSource parserConfig) {
        String newlineString = (String)parserConfig.get(String.class, "newline", (Object)"CRLF");
        if (newlineString == null) {
            throw new IllegalArgumentException(new NullPointerException("newline is unexpectedly null."));
        }
        return (Newline)Newline.valueOf(Newline.class, (String)newlineString);
    }

    static boolean endsWith(Buffer buffer, Newline target) {
        switch (target) {
            case CR: 
            case LF: {
                if (buffer.offset() + buffer.limit() - 1 >= 0) {
                    byte[] last = new byte[1];
                    buffer.getBytes(buffer.limit() - 1, last, 0, 1);
                    return (char)last[0] == target.getFirstCharCode();
                }
                return false;
            }
            case CRLF: {
                if (buffer.offset() + buffer.limit() - 2 >= 0) {
                    byte[] last = new byte[2];
                    buffer.getBytes(buffer.limit() - 2, last, 0, 2);
                    return (char)last[0] == target.getFirstCharCode() && (char)last[1] == target.getSecondCharCode();
                }
                return false;
            }
        }
        return false;
    }
}

