/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.guess;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.embulk.config.ConfigSource;
import org.embulk.spi.Buffer;
import org.embulk.spi.FileInput;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.file.ListFileInput;
import org.embulk.util.guess.GuessUtil;
import org.embulk.util.text.LineDecoder;
import org.embulk.util.text.LineDelimiter;
import org.embulk.util.text.Newline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TextGuessHelper {
    private static final Logger logger = LoggerFactory.getLogger(TextGuessHelper.class);
    private final ConfigMapperFactory configMapperFactory;

    private TextGuessHelper(ConfigMapperFactory configMapperFactory) {
        this.configMapperFactory = configMapperFactory;
    }

    public static TextGuessHelper of(ConfigMapperFactory configMapperFactory) {
        return new TextGuessHelper(configMapperFactory);
    }

    public String toText(ConfigSource config, Buffer sample) {
        Newline newline;
        LineDelimiter lineDelimiter;
        Charset charset;
        ConfigSource parserConfig = config.getNestedOrGetEmpty("parser");
        try {
            charset = GuessUtil.getCharset(parserConfig, this.configMapperFactory, sample);
        }
        catch (IllegalArgumentException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            return null;
        }
        try {
            lineDelimiter = GuessUtil.getLineDelimiter(parserConfig);
        }
        catch (IllegalArgumentException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            return null;
        }
        try {
            newline = GuessUtil.getNewline(parserConfig);
        }
        catch (IllegalArgumentException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            return null;
        }
        ArrayList<Buffer> listBuffer = new ArrayList<Buffer>();
        listBuffer.add(sample);
        ArrayList<ArrayList<Buffer>> listListBuffer = new ArrayList<ArrayList<Buffer>>();
        listListBuffer.add(listBuffer);
        LineDecoder decoder = LineDecoder.of((FileInput)new ListFileInput(listListBuffer), (Charset)charset, (LineDelimiter)lineDelimiter);
        StringBuilder sampleText = new StringBuilder();
        while (decoder.nextFile()) {
            String line;
            boolean first = true;
            while ((line = decoder.poll()) != null) {
                if (first) {
                    first = false;
                } else {
                    sampleText.append(newline.getString());
                }
                sampleText.append(line);
            }
        }
        return sampleText.toString();
    }
}

