/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.guess;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.embulk.util.guess.timeformat.ExpectedPatterns;
import org.embulk.util.guess.timeformat.TimeFormatMatch;
import org.embulk.util.guess.timeformat.TimeFormatPattern;

public final class TimeFormatGuess {
    private TimeFormatGuess() {
    }

    public static TimeFormatGuess of() {
        return new TimeFormatGuess();
    }

    public String guess(Iterable<Object> texts) {
        ArrayList<TimeFormatMatch> matches = new ArrayList<TimeFormatMatch>();
        for (Object textObject : texts) {
            String text = textObject.toString();
            if (text.isEmpty()) continue;
            for (TimeFormatPattern pattern : ExpectedPatterns.PATTERNS) {
                TimeFormatMatch match = pattern.match(text);
                if (match == null) continue;
                matches.add(match);
            }
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return matches.get(0).getFormat();
        }
        return TimeFormatGuess.mergeMostFrequentMatches(matches).getFormat();
    }

    static TimeFormatMatch mergeMostFrequentMatches(List<TimeFormatMatch> matches) {
        Collection<List<TimeFormatMatch>> matchGroups = matches.stream().collect(Collectors.groupingBy(TimeFormatMatch::getIdentifier)).values();
        Optional<List> bestMatchGroup = matchGroups.stream().max(Comparator.comparing(List::size));
        if (!bestMatchGroup.isPresent() || bestMatchGroup.get().isEmpty()) {
            return null;
        }
        TimeFormatMatch bestMatch = (TimeFormatMatch)bestMatchGroup.get().get(0);
        for (TimeFormatMatch match : bestMatchGroup.get()) {
            bestMatch.mergeFrom(match);
        }
        return bestMatch;
    }
}

