/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.guess.timeformat;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.embulk.util.guess.timeformat.GuessDateOrder;

final class GuessDatePicker {
    private static final String DATE_DELIMS = "[\\/\\-\\.]";
    private static final Pattern YMD_DELIM = Pattern.compile(String.format("^(?<year>%s)(?<dateDelim>%s)(?<month>%s)\\k<dateDelim>(?<day>%s)(?<rest>.*?)$", "[1-4][0-9]{3}", "[\\/\\-\\.]", "10|11|12|[0 ]?[0-9]", "31|30|[1-2][0-9]|[0 ]?[1-9]"));
    private static final Pattern YMD_NODELIM = Pattern.compile(String.format("^(?<year>%s)(?<month>%s)(?<day>%s)(?<rest>.*?)$", "[1-4][0-9]{3}", "10|11|12|[0][0-9]", "31|30|[1-2][0-9]|[0][1-9]"));
    private static final Pattern MDY_DELIM = Pattern.compile(String.format("^(?<month>%s)(?<dateDelim>%s)(?<day>%s)\\k<dateDelim>(?<year>%s)(?<rest>.*?)$", "10|11|12|[0 ]?[0-9]", "[\\/\\-\\.]", "31|30|[1-2][0-9]|[0 ]?[1-9]", "[1-4][0-9]{3}"));
    private static final Pattern MDY_NODELIM = Pattern.compile(String.format("^(?<month>%s)(?<day>%s)(?<year>%s)(?<rest>.*?)$", "10|11|12|[0][0-9]", "31|30|[1-2][0-9]|[0][1-9]", "[1-4][0-9]{3}"));
    private static final Pattern DMY_DELIM = Pattern.compile(String.format("^(?<day>%s)(?<dateDelim>%s)(?<month>%s)\\k<dateDelim>(?<year>%s)(?<rest>.*?)$", "31|30|[1-2][0-9]|[0 ]?[1-9]", "[\\/\\-\\.]", "10|11|12|[0 ]?[0-9]", "[1-4][0-9]{3}"));
    private static final Pattern DMY_NODELIM = Pattern.compile(String.format("^(?<day>%s)(?<month>%s)(?<year>%s)(?<rest>.*?)$", "31|30|[1-2][0-9]|[0][1-9]", "10|11|12|[0][0-9]", "[1-4][0-9]{3}"));
    private static DateMatcher[] DATE_MATCHERS = new DateMatcher[]{new DateMatcher(YMD_DELIM, true, GuessDateOrder.YMD), new DateMatcher(YMD_NODELIM, false, GuessDateOrder.YMD), new DateMatcher(MDY_DELIM, true, GuessDateOrder.MDY), new DateMatcher(MDY_NODELIM, false, GuessDateOrder.MDY), new DateMatcher(DMY_DELIM, true, GuessDateOrder.DMY), new DateMatcher(DMY_NODELIM, false, GuessDateOrder.DMY)};
    private final GuessDateOrder order;
    private final String dateDelim;
    private final String year;
    private final String month;
    private final String day;
    private final String rest;

    private GuessDatePicker(GuessDateOrder order, String year, String month, String day, String rest, String dateDelim) {
        this.order = order;
        this.year = year;
        this.month = month;
        this.day = day;
        this.rest = rest;
        this.dateDelim = dateDelim;
    }

    static GuessDatePicker from(String text) {
        for (DateMatcher matcher : DATE_MATCHERS) {
            GuessDatePicker matched = matcher.match(text);
            if (matched == null) continue;
            return matched;
        }
        return null;
    }

    GuessDateOrder getOrder() {
        return this.order;
    }

    String getDateDelim() {
        return this.dateDelim;
    }

    String getYear() {
        return this.year;
    }

    String getMonth() {
        return this.month;
    }

    String getDay() {
        return this.day;
    }

    String getRest() {
        return this.rest;
    }

    private static class DateMatcher {
        private final Pattern pattern;
        private final boolean useDateDelim;
        private final GuessDateOrder order;

        DateMatcher(Pattern pattern, boolean useDateDelim, GuessDateOrder order) {
            this.pattern = pattern;
            this.useDateDelim = useDateDelim;
            this.order = order;
        }

        GuessDatePicker match(String text) {
            Matcher matcher = this.pattern.matcher(text);
            if (matcher.matches()) {
                return new GuessDatePicker(this.order, matcher.group("year"), matcher.group("month"), matcher.group("day"), matcher.group("rest"), this.useDateDelim ? matcher.group("dateDelim") : "");
            }
            return null;
        }
    }
}

