/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.guess.timeformat;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.embulk.util.guess.timeformat.GuessDatePicker;
import org.embulk.util.guess.timeformat.GuessMatch;
import org.embulk.util.guess.timeformat.GuessOption;
import org.embulk.util.guess.timeformat.GuessPart;
import org.embulk.util.guess.timeformat.GuessTimePicker;
import org.embulk.util.guess.timeformat.GuessZonePicker;
import org.embulk.util.guess.timeformat.TimeFormatMatch;
import org.embulk.util.guess.timeformat.TimeFormatPattern;

final class GuessPattern
implements TimeFormatPattern {
    private static final Pattern SPACES = Pattern.compile(String.format("^\\s*$", new Object[0]));

    GuessPattern() {
    }

    @Override
    public TimeFormatMatch match(String text) {
        String restOfTime;
        ArrayList<String> delimiters = new ArrayList<String>();
        ArrayList<GuessPart> parts = new ArrayList<GuessPart>();
        ArrayList<GuessOption> partOptions = new ArrayList<GuessOption>();
        GuessDatePicker datePicker = GuessDatePicker.from(text);
        if (datePicker == null) {
            return null;
        }
        String dateDelim = datePicker.getDateDelim();
        switch (datePicker.getOrder()) {
            case YMD: {
                parts.add(GuessPart.YEAR);
                partOptions.add(GuessOption.NIL);
                delimiters.add(dateDelim);
                parts.add(GuessPart.MONTH);
                partOptions.add(GuessPattern.partHeadingOption(datePicker.getMonth()));
                delimiters.add(dateDelim);
                parts.add(GuessPart.DAY);
                partOptions.add(GuessPattern.partHeadingOption(datePicker.getDay()));
                break;
            }
            case MDY: {
                parts.add(GuessPart.MONTH);
                partOptions.add(GuessPattern.partHeadingOption(datePicker.getMonth()));
                delimiters.add(dateDelim);
                parts.add(GuessPart.DAY);
                partOptions.add(GuessPattern.partHeadingOption(datePicker.getDay()));
                delimiters.add(dateDelim);
                parts.add(GuessPart.YEAR);
                partOptions.add(GuessOption.NIL);
                break;
            }
            case DMY: {
                parts.add(GuessPart.DAY);
                partOptions.add(GuessPattern.partHeadingOption(datePicker.getDay()));
                delimiters.add(dateDelim);
                parts.add(GuessPart.MONTH);
                partOptions.add(GuessPattern.partHeadingOption(datePicker.getMonth()));
                delimiters.add(dateDelim);
                parts.add(GuessPart.YEAR);
                partOptions.add(GuessOption.NIL);
                break;
            }
            default: {
                return null;
            }
        }
        String restOfDate = datePicker.getRest();
        GuessTimePicker timePicker = GuessTimePicker.from(restOfDate, dateDelim);
        if (timePicker != null) {
            String dateTimeDelim = timePicker.getDateTimeDelim();
            String timeDelim = timePicker.getTimeDelim();
            delimiters.add(dateTimeDelim);
            parts.add(GuessPart.HOUR);
            partOptions.add(GuessPattern.partHeadingOption(timePicker.getHour()));
            if (timePicker.getMinute() != null && !timePicker.getMinute().isEmpty()) {
                delimiters.add(timeDelim);
                parts.add(GuessPart.MINUTE);
                partOptions.add(GuessPattern.partHeadingOption(timePicker.getMinute()));
                if (timePicker.getSecond() != null && !timePicker.getSecond().isEmpty()) {
                    delimiters.add(timeDelim);
                    parts.add(GuessPart.SECOND);
                    partOptions.add(GuessPattern.partHeadingOption(timePicker.getSecond()));
                    if (timePicker.getFrac() != null && !timePicker.getFrac().isEmpty()) {
                        delimiters.add(timePicker.getFracDelim());
                        parts.add(GuessPart.FRAC);
                        if (timePicker.getFrac().length() <= 3) {
                            partOptions.add(GuessOption.FRAC_3);
                        } else {
                            partOptions.add(GuessOption.FRAC_N);
                        }
                    }
                }
            }
            restOfTime = timePicker.getRest();
        } else {
            restOfTime = restOfDate;
        }
        GuessZonePicker zonePicker = GuessZonePicker.from(restOfTime);
        if (zonePicker != null) {
            delimiters.add(zonePicker.getZoneSpace());
            parts.add(GuessPart.ZONE);
            if (zonePicker.getZoneOff() != null && !zonePicker.getZoneOff().isEmpty()) {
                if (zonePicker.getZoneOff().contains(":")) {
                    partOptions.add(GuessOption.EXTENDED);
                } else {
                    partOptions.add(GuessOption.SIMPLE);
                }
            } else {
                partOptions.add(GuessOption.ABB);
            }
            return new GuessMatch(delimiters, parts, partOptions);
        }
        if (SPACES.matcher(restOfTime).matches()) {
            return new GuessMatch(delimiters, parts, partOptions);
        }
        return null;
    }

    private static GuessOption partHeadingOption(String text) {
        if (text.charAt(0) == '0') {
            return GuessOption.ZERO;
        }
        if (text.charAt(0) == ' ') {
            return GuessOption.BLANK;
        }
        if (text.length() == 1) {
            return GuessOption.NONE;
        }
        return GuessOption.NIL;
    }
}

