/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.embulk.spi.json.JsonValue;
import org.embulk.util.json.CapturingPointers;
import org.embulk.util.json.InternalJsonValueReader;
import org.embulk.util.json.JsonParseException;

class CapturingDirectMemberNameList
extends CapturingPointers {
    private final Map<String, Integer> memberNames;
    private final int size;

    private CapturingDirectMemberNameList(List<String> memberNames) {
        HashMap<String, Integer> memberNamesMap = new HashMap<String, Integer>();
        int i = 0;
        for (String memberName : memberNames) {
            memberNamesMap.put(memberName, i);
            ++i;
        }
        this.memberNames = Collections.unmodifiableMap(memberNamesMap);
        this.size = memberNames.size();
    }

    static CapturingDirectMemberNameList of(List<String> memberNames) {
        return new CapturingDirectMemberNameList(Collections.unmodifiableList(new ArrayList<String>(memberNames)));
    }

    @Override
    JsonValue[] captureFromParser(JsonParser jacksonParser, InternalJsonValueReader valueReader) throws IOException {
        try {
            JsonToken firstToken = jacksonParser.nextToken();
            if (firstToken == null) {
                return null;
            }
            if (firstToken != JsonToken.START_OBJECT) {
                throw new JsonParseException("Failed to parse JSON: Expected JSON Object, but " + firstToken.toString());
            }
        }
        catch (com.fasterxml.jackson.core.JsonParseException ex) {
            throw new JsonParseException("Failed to parse JSON", ex);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (JsonParseException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new JsonParseException("Failed to parse JSON", ex);
        }
        JsonValue[] values = new JsonValue[this.size];
        for (int i = 0; i < values.length; ++i) {
            values[i] = null;
        }
        while (true) {
            JsonToken token;
            if ((token = jacksonParser.nextToken()) == null) {
                throw new JsonParseException("Failed to parse JSON: Unexpected end");
            }
            if (token == JsonToken.END_OBJECT) break;
            if (token != JsonToken.FIELD_NAME) {
                throw new JsonParseException("Failed to parse JSON: Unexpected token: " + token.toString());
            }
            String key = jacksonParser.getCurrentName();
            if (key == null) {
                throw new JsonParseException("Unexpected token " + token + " at " + jacksonParser.getTokenLocation());
            }
            Integer index = this.memberNames.get(key);
            if (index == null) {
                valueReader.skip(jacksonParser);
                continue;
            }
            values[index.intValue()] = valueReader.read(jacksonParser);
        }
        return values;
    }
}

