/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import java.io.IOException;
import java.util.List;
import org.embulk.spi.json.JsonValue;
import org.embulk.util.json.CapturingPointers;
import org.embulk.util.json.InternalJsonValueReader;
import org.embulk.util.json.JsonPointerTree;
import org.embulk.util.json.TreeBasedCapturer;

class CapturingJsonPointerList
extends CapturingPointers {
    private final JsonPointerTree tree;
    private final int size;

    private CapturingJsonPointerList(JsonPointerTree tree, int size) {
        this.tree = tree;
        this.size = size;
    }

    static CapturingJsonPointerList of(List<JsonPointer> pointers) {
        return new CapturingJsonPointerList(JsonPointerTree.of(pointers), pointers.size());
    }

    @Override
    JsonValue[] captureFromParser(JsonParser parser, InternalJsonValueReader valueReader) throws IOException {
        TreeBasedCapturer capturer = new TreeBasedCapturer(parser, this.tree, this.size, valueReader);
        boolean isFirstAvailable = capturer.next();
        if (!isFirstAvailable) {
            return null;
        }
        while (capturer.next()) {
        }
        return capturer.peekValues();
    }

    int size() {
        return this.size;
    }
}

