/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.embulk.spi.json.JsonValue;
import org.embulk.util.json.CapturingDirectMemberNameList;
import org.embulk.util.json.CapturingJsonPointerList;
import org.embulk.util.json.CapturingPointerToRoot;
import org.embulk.util.json.InternalJsonValueReader;

public abstract class CapturingPointers {
    private static final Pattern TILDE = Pattern.compile("~");
    private static final Pattern SLASH = Pattern.compile("/");

    CapturingPointers() {
    }

    public static Builder builder() {
        return new Builder();
    }

    abstract JsonValue[] captureFromParser(JsonParser var1, InternalJsonValueReader var2) throws IOException;

    static JsonPointer compileMemberNameToJsonPointer(String memberName) {
        if (!memberName.contains("~") && !memberName.contains("/")) {
            return JsonPointer.compile((String)("/" + memberName));
        }
        String untilde = TILDE.matcher(memberName).replaceAll("~0");
        return JsonPointer.compile((String)("/" + SLASH.matcher(untilde).replaceAll("~1")));
    }

    public static class Builder {
        private final ArrayList<String> directMemberNames = new ArrayList();
        private final ArrayList<JsonPointer> jsonPointers = new ArrayList();
        private final ArrayList<RuntimeException> jsonPointerExceptions = new ArrayList();
        private boolean hasAtLeastOneJsonPointer = false;

        Builder() {
        }

        public Builder addDirectMemberName(String directMemberName) {
            JsonPointer compiledPointer;
            this.directMemberNames.add(directMemberName);
            try {
                compiledPointer = CapturingPointers.compileMemberNameToJsonPointer(directMemberName);
            }
            catch (RuntimeException ex) {
                this.jsonPointerExceptions.add(ex);
                return this;
            }
            this.jsonPointers.add(compiledPointer);
            return this;
        }

        public Builder addJsonPointer(String jsonPointer) {
            this.hasAtLeastOneJsonPointer = true;
            this.directMemberNames.add(null);
            this.jsonPointers.add(JsonPointer.compile((String)jsonPointer));
            return this;
        }

        public Builder addJsonPointer(JsonPointer jsonPointer) {
            this.hasAtLeastOneJsonPointer = true;
            this.directMemberNames.add(null);
            this.jsonPointers.add(jsonPointer);
            return this;
        }

        public CapturingPointers build() {
            assert (this.directMemberNames.size() == this.jsonPointers.size());
            if (this.directMemberNames.isEmpty()) {
                return CapturingPointerToRoot.INSTANCE;
            }
            if (this.hasAtLeastOneJsonPointer) {
                if (!this.jsonPointerExceptions.isEmpty()) {
                    IllegalArgumentException ex = new IllegalArgumentException("Invalid JSON Pointer(s) specified.", this.jsonPointerExceptions.get(0));
                    for (RuntimeException suppressed : this.jsonPointerExceptions) {
                        ex.addSuppressed(suppressed);
                    }
                    throw ex;
                }
                return CapturingJsonPointerList.of(this.jsonPointers);
            }
            return CapturingDirectMemberNameList.of(this.directMemberNames);
        }
    }
}

