/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.json;

import com.fasterxml.jackson.core.filter.TokenFilter;

class FlattenJsonArrayFilter
extends TokenFilter {
    private final int depth;

    FlattenJsonArrayFilter(int depth) {
        if (depth <= 0) {
            throw new IllegalArgumentException("FlattenJsonArrayFilter must receive at least 1 as depth.");
        }
        this.depth = depth;
    }

    public TokenFilter includeElement(int index) {
        if (this.depth <= 1) {
            return TokenFilter.INCLUDE_ALL;
        }
        return new FlattenJsonArrayFilter(this.depth - 1);
    }

    public TokenFilter includeProperty(String name) {
        return null;
    }

    public String toString() {
        return "[FlattenJsonArrayFilter depth: " + this.depth + "]";
    }
}

