/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import org.embulk.spi.json.JsonArray;
import org.embulk.spi.json.JsonBoolean;
import org.embulk.spi.json.JsonDouble;
import org.embulk.spi.json.JsonLong;
import org.embulk.spi.json.JsonNull;
import org.embulk.spi.json.JsonObject;
import org.embulk.spi.json.JsonString;
import org.embulk.spi.json.JsonValue;
import org.embulk.util.json.JsonParseException;

final class InternalJsonValueReader {
    private final boolean hasLiteralsWithNumbers;
    private final boolean hasFallbacksForUnparsableNumbers;
    private final double defaultDouble;
    private final long defaultLong;

    InternalJsonValueReader(boolean hasLiteralsWithNumbers, boolean hasFallbacksForUnparsableNumbers, double defaultDouble, long defaultLong) {
        this.hasLiteralsWithNumbers = hasLiteralsWithNumbers;
        this.hasFallbacksForUnparsableNumbers = hasFallbacksForUnparsableNumbers;
        this.defaultDouble = defaultDouble;
        this.defaultLong = defaultLong;
    }

    boolean hasLiteralsWithNumbers() {
        return this.hasLiteralsWithNumbers;
    }

    boolean hasFallbacksForUnparsableNumbers() {
        return this.hasFallbacksForUnparsableNumbers;
    }

    double defaultDouble() {
        return this.defaultDouble;
    }

    long defaultLong() {
        return this.defaultLong;
    }

    JsonValue read(JsonParser jacksonParser) throws IOException {
        try {
            JsonToken token = jacksonParser.nextToken();
            if (token == null) {
                return null;
            }
            return this.readJsonValue(jacksonParser, token);
        }
        catch (com.fasterxml.jackson.core.JsonParseException ex) {
            throw new JsonParseException("Failed to parse JSON", ex);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (JsonParseException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new JsonParseException("Failed to parse JSON", ex);
        }
    }

    void skip(JsonParser jacksonParser) throws IOException {
        try {
            JsonToken token = jacksonParser.nextToken();
            if (token == null) {
                throw new JsonParseException("Failed to parse JSON");
            }
            this.skipJsonValue(jacksonParser, token);
        }
        catch (com.fasterxml.jackson.core.JsonParseException ex) {
            throw new JsonParseException("Failed to parse JSON", ex);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (JsonParseException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new JsonParseException("Failed to parse JSON", ex);
        }
    }

    private JsonValue readJsonValue(JsonParser jacksonParser, JsonToken token) throws IOException {
        switch (token) {
            case VALUE_NULL: {
                return JsonNull.NULL;
            }
            case VALUE_TRUE: {
                return JsonBoolean.TRUE;
            }
            case VALUE_FALSE: {
                return JsonBoolean.FALSE;
            }
            case VALUE_NUMBER_FLOAT: {
                if (this.hasLiteralsWithNumbers) {
                    return JsonDouble.withLiteral((double)this.getDoubleValue(jacksonParser), (String)jacksonParser.getValueAsString());
                }
                return JsonDouble.of((double)this.getDoubleValue(jacksonParser));
            }
            case VALUE_NUMBER_INT: {
                if (this.hasLiteralsWithNumbers) {
                    return JsonLong.withLiteral((long)this.getLongValue(jacksonParser), (String)jacksonParser.getValueAsString());
                }
                return JsonLong.of((long)this.getLongValue(jacksonParser));
            }
            case VALUE_STRING: {
                return JsonString.of((String)jacksonParser.getText());
            }
            case START_ARRAY: {
                ArrayList<JsonValue> list = new ArrayList<JsonValue>();
                while (true) {
                    JsonToken nextToken;
                    if ((nextToken = jacksonParser.nextToken()) == null) {
                        throw new JsonParseException("Unexpected end of JSON at " + jacksonParser.getTokenLocation() + " while expecting an element of an array");
                    }
                    if (nextToken == JsonToken.END_ARRAY) {
                        return JsonArray.ofList(list);
                    }
                    list.add(this.readJsonValue(jacksonParser, nextToken));
                }
            }
            case START_OBJECT: {
                ArrayList<String> keys = new ArrayList<String>();
                ArrayList<JsonValue> values = new ArrayList<JsonValue>();
                while (true) {
                    JsonToken nextToken;
                    if ((nextToken = jacksonParser.nextToken()) == null) {
                        throw new JsonParseException("Unexpected end of JSON at " + jacksonParser.getTokenLocation() + " while expecting a key of an object");
                    }
                    if (nextToken == JsonToken.END_OBJECT) {
                        return JsonObject.ofUnsafe((String[])keys.toArray(new String[keys.size()]), (JsonValue[])values.toArray(new JsonValue[values.size()]));
                    }
                    if (nextToken != JsonToken.FIELD_NAME) {
                        throw new JsonParseException("Unexpected token " + nextToken + " at " + jacksonParser.getTokenLocation());
                    }
                    String key = jacksonParser.getCurrentName();
                    if (key == null) {
                        throw new JsonParseException("Unexpected token " + nextToken + " at " + jacksonParser.getTokenLocation());
                    }
                    JsonToken nextNextToken = jacksonParser.nextToken();
                    if (nextNextToken == null) {
                        throw new JsonParseException("Unexpected end of JSON at " + jacksonParser.getTokenLocation() + " while expecting a value of an object");
                    }
                    JsonValue value = this.readJsonValue(jacksonParser, nextNextToken);
                    keys.add(key);
                    values.add(value);
                }
            }
        }
        throw new JsonParseException("Unexpected token " + token + " at " + jacksonParser.getTokenLocation());
    }

    private void skipJsonValue(JsonParser jacksonParser, JsonToken token) throws IOException {
        switch (token) {
            case VALUE_NULL: 
            case VALUE_TRUE: 
            case VALUE_FALSE: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: 
            case VALUE_STRING: {
                return;
            }
            case START_ARRAY: {
                while (true) {
                    JsonToken nextToken;
                    if ((nextToken = jacksonParser.nextToken()) == null) {
                        throw new JsonParseException("Unexpected end of JSON at " + jacksonParser.getTokenLocation() + " while expecting an element of an array");
                    }
                    if (nextToken == JsonToken.END_ARRAY) {
                        return;
                    }
                    this.skipJsonValue(jacksonParser, nextToken);
                }
            }
            case START_OBJECT: {
                while (true) {
                    JsonToken nextToken;
                    if ((nextToken = jacksonParser.nextToken()) == null) {
                        throw new JsonParseException("Unexpected end of JSON at " + jacksonParser.getTokenLocation() + " while expecting a key of an object");
                    }
                    if (nextToken == JsonToken.END_OBJECT) {
                        return;
                    }
                    if (nextToken != JsonToken.FIELD_NAME) {
                        throw new JsonParseException("Unexpected token " + nextToken + " at " + jacksonParser.getTokenLocation());
                    }
                    JsonToken nextNextToken = jacksonParser.nextToken();
                    if (nextNextToken == null) {
                        throw new JsonParseException("Unexpected end of JSON at " + jacksonParser.getTokenLocation() + " while expecting a value of an object");
                    }
                    this.skipJsonValue(jacksonParser, nextNextToken);
                }
            }
        }
        throw new JsonParseException("Unexpected token " + token + " at " + jacksonParser.getTokenLocation());
    }

    private double getDoubleValue(JsonParser jacksonParser) throws IOException {
        try {
            return jacksonParser.getDoubleValue();
        }
        catch (IOException ex) {
            if (this.hasFallbacksForUnparsableNumbers) {
                return this.defaultDouble;
            }
            throw ex;
        }
    }

    private long getLongValue(JsonParser jacksonParser) throws IOException {
        try {
            return jacksonParser.getLongValue();
        }
        catch (IOException ex) {
            if (this.hasFallbacksForUnparsableNumbers) {
                return this.defaultLong;
            }
            throw ex;
        }
    }
}

