/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.filter.FilteringParserDelegate;
import com.fasterxml.jackson.core.filter.JsonPointerBasedFilter;
import com.fasterxml.jackson.core.filter.TokenFilter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import org.embulk.util.json.JsonParseException;
import org.msgpack.value.ImmutableStringValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

@Deprecated
public class JsonParser {
    private final JsonFactory factory = new JsonFactory();

    public JsonParser() {
        this.factory.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
        this.factory.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
    }

    public Stream open(InputStream in) throws IOException {
        return this.openWithOffsetInJsonPointer(in, null);
    }

    public Stream openWithOffsetInJsonPointer(InputStream in, String offsetInJsonPointer) throws IOException {
        return new StreamParseContext(this.factory, in, offsetInJsonPointer);
    }

    public Value parse(String json) {
        return this.parseWithOffsetInJsonPointer(json, null);
    }

    public Value parseWithOffsetInJsonPointer(String json, String offsetInJsonPointer) {
        return new SingleParseContext(this.factory, json, offsetInJsonPointer).parse();
    }

    private static String sampleJsonString(String json) {
        if (json.length() < 100) {
            return json;
        }
        return json.substring(0, 97) + "...";
    }

    private static com.fasterxml.jackson.core.JsonParser wrapWithPointerFilter(com.fasterxml.jackson.core.JsonParser baseParser, String offsetInJsonPointer) {
        return new FilteringParserDelegate(baseParser, (TokenFilter)new JsonPointerBasedFilter(offsetInJsonPointer), false, true);
    }

    private static abstract class AbstractParseContext {
        private final com.fasterxml.jackson.core.JsonParser parser;

        public AbstractParseContext(com.fasterxml.jackson.core.JsonParser parser) {
            this.parser = parser;
        }

        protected final void closeParser() throws IOException {
            this.parser.close();
        }

        protected abstract String sampleJsonString();

        public final Value next() throws IOException {
            try {
                JsonToken token = this.parser.nextToken();
                if (token == null) {
                    return null;
                }
                return this.jsonTokenToValue(token);
            }
            catch (com.fasterxml.jackson.core.JsonParseException ex) {
                throw new JsonParseException("Failed to parse JSON: " + this.sampleJsonString(), ex);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (JsonParseException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new JsonParseException("Failed to parse JSON: " + this.sampleJsonString(), ex);
            }
        }

        private final Value jsonTokenToValue(JsonToken token) throws IOException {
            switch (token) {
                case VALUE_NULL: {
                    return ValueFactory.newNil();
                }
                case VALUE_TRUE: {
                    return ValueFactory.newBoolean((boolean)true);
                }
                case VALUE_FALSE: {
                    return ValueFactory.newBoolean((boolean)false);
                }
                case VALUE_NUMBER_FLOAT: {
                    return ValueFactory.newFloat((double)this.parser.getDoubleValue());
                }
                case VALUE_NUMBER_INT: {
                    try {
                        return ValueFactory.newInteger((long)this.parser.getLongValue());
                    }
                    catch (com.fasterxml.jackson.core.JsonParseException ex) {
                        return ValueFactory.newInteger((BigInteger)this.parser.getBigIntegerValue());
                    }
                }
                case VALUE_STRING: {
                    return ValueFactory.newString((String)this.parser.getText());
                }
                case START_ARRAY: {
                    ArrayList<Value> list = new ArrayList<Value>();
                    while (true) {
                        JsonToken nextToken;
                        if ((nextToken = this.parser.nextToken()) == JsonToken.END_ARRAY) {
                            return ValueFactory.newArray(list);
                        }
                        if (nextToken == null) {
                            throw new JsonParseException("Unexpected end of JSON at " + this.parser.getTokenLocation() + " while expecting an element of an array: " + this.sampleJsonString());
                        }
                        list.add(this.jsonTokenToValue(nextToken));
                    }
                }
                case START_OBJECT: {
                    HashMap<ImmutableStringValue, Value> map = new HashMap<ImmutableStringValue, Value>();
                    JsonToken nextToken;
                    while ((nextToken = this.parser.nextToken()) != JsonToken.END_OBJECT) {
                        if (nextToken == null) {
                            throw new JsonParseException("Unexpected end of JSON at " + this.parser.getTokenLocation() + " while expecting a key of object: " + this.sampleJsonString());
                        }
                        String key = this.parser.getCurrentName();
                        if (key == null) {
                            throw new JsonParseException("Unexpected token " + nextToken + " at " + this.parser.getTokenLocation() + ": " + this.sampleJsonString());
                        }
                        JsonToken nextNextToken = this.parser.nextToken();
                        if (nextNextToken == null) {
                            throw new JsonParseException("Unexpected end of JSON at " + this.parser.getTokenLocation() + " while expecting a value of object: " + this.sampleJsonString());
                        }
                        Value value = this.jsonTokenToValue(nextNextToken);
                        map.put(ValueFactory.newString((String)key), value);
                    }
                    return ValueFactory.newMap(map);
                }
            }
            throw new JsonParseException("Unexpected token " + token + " at " + this.parser.getTokenLocation() + ": " + this.sampleJsonString());
        }
    }

    private static class SingleParseContext
    extends AbstractParseContext {
        private final String json;

        public SingleParseContext(JsonFactory factory, String json, String offsetInJsonPointer) {
            super(SingleParseContext.createParser(factory, json, Optional.ofNullable(offsetInJsonPointer)));
            this.json = json;
        }

        private static com.fasterxml.jackson.core.JsonParser createParser(JsonFactory factory, String json, Optional<String> offsetInJsonPointer) {
            try {
                com.fasterxml.jackson.core.JsonParser baseParser = factory.createParser(json);
                return offsetInJsonPointer.map(p -> JsonParser.wrapWithPointerFilter(baseParser, p)).orElse(baseParser);
            }
            catch (Exception ex) {
                throw new JsonParseException("Failed to parse JSON: " + JsonParser.sampleJsonString(json), ex);
            }
        }

        public Value parse() {
            try {
                Value v = this.next();
                if (v == null) {
                    throw new JsonParseException("Unable to parse empty string");
                }
                return v;
            }
            catch (IOException ex) {
                throw new JsonParseException("Failed to parse JSON: " + this.sampleJsonString(), ex);
            }
        }

        @Override
        protected String sampleJsonString() {
            return JsonParser.sampleJsonString(this.json);
        }
    }

    private static class StreamParseContext
    extends AbstractParseContext
    implements Stream {
        public StreamParseContext(JsonFactory factory, InputStream in, String offsetInJsonPointer) throws IOException {
            super(StreamParseContext.createParser(factory, in, Optional.ofNullable(offsetInJsonPointer)));
        }

        private static com.fasterxml.jackson.core.JsonParser createParser(JsonFactory factory, InputStream in, Optional<String> offsetInJsonPointer) throws IOException {
            try {
                com.fasterxml.jackson.core.JsonParser baseParser = factory.createParser(in);
                return offsetInJsonPointer.map(p -> JsonParser.wrapWithPointerFilter(baseParser, p)).orElse(baseParser);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new JsonParseException("Failed to parse JSON", ex);
            }
        }

        @Override
        public void close() throws IOException {
            this.closeParser();
        }

        @Override
        protected String sampleJsonString() {
            return "in";
        }
    }

    public static interface Stream
    extends Closeable {
        public Value next() throws IOException;

        @Override
        public void close() throws IOException;
    }
}

