/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.json;

import com.fasterxml.jackson.core.JsonPointer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class JsonPointerTree
extends AbstractMap<String, JsonPointerTree> {
    static final JsonPointerTree INVALID = new JsonPointerTree();
    private final Map<String, JsonPointerTree> nextSegments;
    private final List<Integer> captures;

    private JsonPointerTree(HashMap<String, JsonPointerTree> nextSegments, ArrayList<Integer> captures) {
        this.nextSegments = Collections.unmodifiableMap(nextSegments);
        this.captures = captures.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(captures);
    }

    private JsonPointerTree() {
        this.nextSegments = null;
        this.captures = Collections.emptyList();
    }

    static Builder builder() {
        return new Builder();
    }

    static JsonPointerTree of(JsonPointer ... pointers) {
        Builder builder = JsonPointerTree.builder();
        for (int i = 0; i < pointers.length; ++i) {
            builder.add(pointers[i], i);
        }
        return builder.build();
    }

    static JsonPointerTree of(List<JsonPointer> pointers) {
        Builder builder = JsonPointerTree.builder();
        int i = 0;
        for (JsonPointer pointer : pointers) {
            builder.add(pointer, i);
            ++i;
        }
        return builder.build();
    }

    @Override
    public Set<Map.Entry<String, JsonPointerTree>> entrySet() {
        if (this.nextSegments == null) {
            return Collections.emptySet();
        }
        return this.nextSegments.entrySet();
    }

    boolean isInvalid() {
        return this.nextSegments == null;
    }

    List<Integer> captures() {
        return this.captures;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nextSegments, this.captures);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (otherObject == this) {
            return true;
        }
        if (!(otherObject instanceof JsonPointerTree)) {
            return false;
        }
        JsonPointerTree other = (JsonPointerTree)otherObject;
        return Objects.equals(this.nextSegments, other.nextSegments) && Objects.equals(this.captures, other.captures);
    }

    @Override
    public String toString() {
        if (this.nextSegments == null) {
            return "(invalid)";
        }
        if (this.captures.isEmpty()) {
            return this.nextSegments.toString();
        }
        return this.captures.toString() + ":" + this.nextSegments.toString();
    }

    static boolean isJsonPointerEmpty(JsonPointer pointer) {
        return pointer.tail() == null;
    }

    static boolean isJsonPointerRoot(JsonPointer pointer) {
        return "/".equals(pointer.toString());
    }

    static class Builder {
        private final HashMap<String, Builder> nextSegments = new HashMap();
        private final ArrayList<Integer> captures = new ArrayList();

        private Builder() {
        }

        JsonPointerTree build() {
            HashMap<String, JsonPointerTree> fixedTokens = new HashMap<String, JsonPointerTree>();
            for (Map.Entry<String, Builder> entry : this.nextSegments.entrySet()) {
                fixedTokens.put(entry.getKey(), entry.getValue().build());
            }
            return new JsonPointerTree(fixedTokens, this.captures);
        }

        Builder add(JsonPointer pointer, int capture) {
            if (JsonPointerTree.isJsonPointerEmpty(pointer)) {
                throw new IllegalArgumentException("Empty JSON Pointer \"\" is not permitted.");
            }
            if (JsonPointerTree.isJsonPointerRoot(pointer)) {
                this.captures.add(capture);
                return this;
            }
            List<String> splitPointers = Builder.split(pointer);
            Builder node = this;
            for (String pointerElement : splitPointers) {
                node = node.addOnThis(pointerElement);
            }
            node.captures.add(capture);
            return this;
        }

        private Builder addOnThis(String element) {
            Builder node = this.nextSegments.get(element);
            if (node == null) {
                Builder newNode = new Builder();
                this.nextSegments.put(element, newNode);
                return newNode;
            }
            return node;
        }

        static List<String> split(JsonPointer pointer) {
            ArrayList<String> list = new ArrayList<String>();
            for (JsonPointer tail = Objects.requireNonNull(pointer); tail != null && !JsonPointerTree.isJsonPointerEmpty(tail); tail = tail.tail()) {
                list.add(tail.getMatchingProperty());
            }
            return Collections.unmodifiableList(list);
        }
    }
}

