/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.filter.FilteringParserDelegate;
import com.fasterxml.jackson.core.filter.JsonPointerBasedFilter;
import com.fasterxml.jackson.core.filter.TokenFilter;
import com.fasterxml.jackson.core.json.PackageVersion;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.embulk.spi.json.JsonValue;
import org.embulk.util.json.CapturingPointers;
import org.embulk.util.json.FlattenJsonArrayFilter;
import org.embulk.util.json.InternalJsonValueReader;

public final class JsonValueParser
implements Closeable {
    private final JsonParser jacksonParser;
    private final InternalJsonValueReader valueReader;
    private final int depthToFlattenJsonArrays;
    private final boolean hasLiteralsWithNumbers;
    private final boolean hasFallbacksForUnparsableNumbers;
    private final double defaultDouble;
    private final long defaultLong;

    private JsonValueParser(JsonParser jacksonParser, int depthToFlattenJsonArrays, boolean hasLiteralsWithNumbers, boolean hasFallbacksForUnparsableNumbers, double defaultDouble, long defaultLong) {
        this.jacksonParser = Objects.requireNonNull(jacksonParser);
        this.valueReader = new InternalJsonValueReader(hasLiteralsWithNumbers, hasFallbacksForUnparsableNumbers, defaultDouble, defaultLong);
        this.depthToFlattenJsonArrays = depthToFlattenJsonArrays;
        this.hasLiteralsWithNumbers = hasLiteralsWithNumbers;
        this.hasFallbacksForUnparsableNumbers = hasFallbacksForUnparsableNumbers;
        this.defaultDouble = defaultDouble;
        this.defaultLong = defaultLong;
    }

    public static Builder builder() {
        JsonFactory factory = new JsonFactory();
        factory.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
        factory.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
        return JsonValueParser.builder(factory);
    }

    public static Builder builder(JsonFactory jsonFactory) {
        JsonValueParser.assertJacksonVersion();
        return new Builder(jsonFactory);
    }

    public JsonValue readJsonValue() throws IOException {
        return this.valueReader.read(this.jacksonParser);
    }

    public JsonValue[] captureJsonValues(CapturingPointers capturingPointers) throws IOException {
        return capturingPointers.captureFromParser(this.jacksonParser, this.valueReader);
    }

    @Override
    public final void close() throws IOException {
        this.jacksonParser.close();
    }

    private static void assertJacksonVersion() {
        if (PackageVersion.VERSION.getMajorVersion() != 2) {
            throw new UnsupportedOperationException("embulk-util-json is not used with Jackson 2.");
        }
        int minor = PackageVersion.VERSION.getMinorVersion();
        if (minor < 14 || minor == 15 && PackageVersion.VERSION.getPatchLevel() <= 2) {
            throw new UnsupportedOperationException("embulk-util-json is not used with Jackson 2.15.3 or later.");
        }
    }

    public static final class Builder {
        private final JsonFactory factory;
        private JsonPointer root;
        private int depthToFlattenJsonArrays;
        private boolean hasLiteralsWithNumbers;
        private boolean hasFallbacksForUnparsableNumbers;
        private double defaultDouble;
        private long defaultLong;

        Builder(JsonFactory factory) {
            this.factory = Objects.requireNonNull(factory);
            this.root = null;
            this.depthToFlattenJsonArrays = 0;
            this.hasLiteralsWithNumbers = false;
            this.hasFallbacksForUnparsableNumbers = false;
            this.defaultDouble = 0.0;
            this.defaultLong = 0L;
        }

        public Builder root(JsonPointer root) {
            this.root = root;
            return this;
        }

        public Builder root(String root) {
            this.root = JsonPointer.compile((String)root);
            return this;
        }

        public Builder setDepthToFlattenJsonArrays(int depthToFlattenJsonArrays) {
            this.depthToFlattenJsonArrays = depthToFlattenJsonArrays;
            return this;
        }

        public Builder enableSupplementalLiteralsWithNumbers() {
            this.hasLiteralsWithNumbers = true;
            return this;
        }

        public Builder fallbackForUnparsableNumbers(double defaultDouble, long defaultLong) {
            this.hasFallbacksForUnparsableNumbers = true;
            this.defaultDouble = defaultDouble;
            this.defaultLong = defaultLong;
            return this;
        }

        public JsonValueParser build(String json) throws IOException {
            return new JsonValueParser(this.buildJacksonParser(json), this.depthToFlattenJsonArrays, this.hasLiteralsWithNumbers, this.hasFallbacksForUnparsableNumbers, this.defaultDouble, this.defaultLong);
        }

        public JsonValueParser build(InputStream jsonStream) throws IOException {
            return new JsonValueParser(this.buildJacksonParser(jsonStream), this.depthToFlattenJsonArrays, this.hasLiteralsWithNumbers, this.hasFallbacksForUnparsableNumbers, this.defaultDouble, this.defaultLong);
        }

        private JsonParser buildJacksonParser(String json) throws IOException {
            return this.extendJacksonParser(this.factory.createParser(Objects.requireNonNull(json)));
        }

        private JsonParser buildJacksonParser(InputStream jsonStream) throws IOException {
            return this.extendJacksonParser(this.factory.createParser(Objects.requireNonNull(jsonStream)));
        }

        private JsonParser extendJacksonParser(JsonParser baseParser) {
            JsonParser parser = baseParser;
            if (this.root != null) {
                parser = new FilteringParserDelegate(parser, (TokenFilter)new JsonPointerBasedFilter(this.root), TokenFilter.Inclusion.ONLY_INCLUDE_ALL, true);
            }
            if (this.depthToFlattenJsonArrays > 0) {
                parser = new FilteringParserDelegate(parser, (TokenFilter)new FlattenJsonArrayFilter(this.depthToFlattenJsonArrays), TokenFilter.Inclusion.ONLY_INCLUDE_ALL, true);
            }
            return parser;
        }
    }
}

