/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.embulk.spi.json.JsonArray;
import org.embulk.spi.json.JsonBoolean;
import org.embulk.spi.json.JsonDouble;
import org.embulk.spi.json.JsonLong;
import org.embulk.spi.json.JsonNull;
import org.embulk.spi.json.JsonObject;
import org.embulk.spi.json.JsonString;
import org.embulk.spi.json.JsonValue;
import org.embulk.util.json.InternalJsonValueReader;
import org.embulk.util.json.JsonParseException;
import org.embulk.util.json.JsonPointerTree;

class TreeBasedCapturer {
    private final JsonParser parser;
    private final JsonPointerTree tree;
    private final boolean hasRootToCapture;
    private final int size;
    private final InternalJsonValueReader valueReader;
    private final ArrayDeque<JsonPointerTree> pointerStack;
    private final ArrayDeque<ParsingContext> parsingStack;
    private final ArrayDeque<StructureBuilder> builderStack;
    private final JsonValue[] values;
    private boolean hasFinished;

    TreeBasedCapturer(JsonParser parser, JsonPointerTree tree, int size, InternalJsonValueReader valueReader) {
        this.parser = parser;
        this.tree = tree;
        this.hasRootToCapture = this.tree.captures().isEmpty();
        this.size = size;
        this.valueReader = valueReader;
        this.pointerStack = new ArrayDeque();
        this.pointerStack.push(this.tree);
        this.parsingStack = new ArrayDeque();
        this.builderStack = new ArrayDeque();
        this.hasFinished = false;
        this.values = new JsonValue[size];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
    }

    boolean next() throws IOException {
        List<Integer> captures;
        Object toBePointer;
        ParsingContext context;
        JsonToken token;
        if (this.hasFinished) {
            return false;
        }
        try {
            token = this.parser.nextToken();
        }
        catch (com.fasterxml.jackson.core.JsonParseException ex) {
            throw new JsonParseException("Failed to parse JSON", ex);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (JsonParseException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new JsonParseException("Failed to parse JSON", ex);
        }
        if (token == null) {
            return false;
        }
        JsonPointerTree parentPointer = this.pointerStack.peekFirst();
        if (this.hasRootToCapture && this.parsingStack.isEmpty() && token.isStructStart()) {
            if (token == JsonToken.START_ARRAY) {
                this.builderStack.push(new ArrayBuilder());
            } else if (token == JsonToken.START_OBJECT) {
                this.builderStack.push(new ObjectBuilder());
            }
        }
        if ((token.isScalarValue() || token.isStructStart()) && !this.parsingStack.isEmpty()) {
            context = this.parsingStack.getFirst();
            if (context.isObject()) {
                String propertyName = context.getPropertyName();
                if (propertyName == null) {
                    throw new JsonParseException("Value in JSON Object before any field comes.");
                }
                toBePointer = (JsonPointerTree)parentPointer.get(propertyName);
                if (toBePointer != null) {
                    this.pointerStack.push((JsonPointerTree)parentPointer.get(propertyName));
                } else {
                    this.pointerStack.push(JsonPointerTree.INVALID);
                }
            } else {
                context.incrementIndex();
                String indexInString = context.getIndexInString();
                toBePointer = (JsonPointerTree)parentPointer.get(indexInString);
                if (toBePointer != null) {
                    this.pointerStack.push((JsonPointerTree)parentPointer.get(indexInString));
                } else {
                    this.pointerStack.push(JsonPointerTree.INVALID);
                }
            }
        }
        if (token == JsonToken.START_ARRAY) {
            this.parsingStack.push(new ParsingContext(false));
            captures = this.pointerStack.getFirst().captures();
            if (!captures.isEmpty() || !this.builderStack.isEmpty()) {
                this.builderStack.push(new ArrayBuilder());
            }
        } else if (token == JsonToken.END_ARRAY) {
            if (this.parsingStack.isEmpty() || this.parsingStack.pop().isObject()) {
                throw new JsonParseException("END_ARRAY does not match.");
            }
        } else if (token == JsonToken.START_OBJECT) {
            this.parsingStack.push(new ParsingContext(true));
            captures = this.pointerStack.getFirst().captures();
            if (!captures.isEmpty() || !this.builderStack.isEmpty()) {
                this.builderStack.push(new ObjectBuilder());
            }
        } else if (token == JsonToken.END_OBJECT) {
            if (this.parsingStack.isEmpty() || !this.parsingStack.pop().isObject()) {
                throw new JsonParseException("END_OBJECT does not match.");
            }
        } else if (token == JsonToken.FIELD_NAME) {
            if (this.parsingStack.isEmpty()) {
                throw new JsonParseException("FIELD_NAME out of JSON Object.");
            }
            context = this.parsingStack.getFirst();
            if (!context.isObject()) {
                throw new JsonParseException("FIELD_NAME in JSON Array.");
            }
            context.setPropertyName(this.parser.getCurrentName());
        } else if (!token.isScalarValue()) {
            throw new JsonParseException("Unexpected token in JSON: " + token.toString());
        }
        if (token.isScalarValue() || token.isStructEnd()) {
            JsonValue value;
            if (token.isScalarValue()) {
                value = this.getScalarValue(token);
            } else if (this.builderStack.isEmpty()) {
                value = null;
            } else {
                StructureBuilder thisBuilder = this.builderStack.pop();
                if (token == JsonToken.END_ARRAY && thisBuilder.isObject()) {
                    throw new JsonParseException("END_ARRAY does not match.");
                }
                if (token == JsonToken.END_OBJECT && thisBuilder.isArray()) {
                    throw new JsonParseException("END_OBJECT does not match.");
                }
                value = thisBuilder.build();
            }
            if (value != null) {
                JsonPointerTree thisPointer = this.pointerStack.peekFirst();
                assert (thisPointer != null);
                toBePointer = thisPointer.captures().iterator();
                while (toBePointer.hasNext()) {
                    int capture = (Integer)toBePointer.next();
                    this.values[capture] = value;
                }
                if (!this.builderStack.isEmpty()) {
                    StructureBuilder parentBuilder = this.builderStack.getFirst();
                    if (parentBuilder.isArray()) {
                        parentBuilder.add(value);
                    } else {
                        ParsingContext context2 = this.parsingStack.peekFirst();
                        if (context2 != null) {
                            if (!context2.isObject()) {
                                throw new JsonParseException("END_OBJECT does not match.");
                            }
                            parentBuilder.put(context2.getPropertyName(), value);
                        }
                    }
                }
            }
        }
        if (token.isScalarValue() || token.isStructEnd()) {
            if (this.pointerStack.isEmpty()) {
                throw new JsonParseException("Too many structure ends.");
            }
            if (this.parsingStack.isEmpty()) {
                assert (this.pointerStack.size() == 1);
            } else {
                this.pointerStack.pop();
            }
        }
        if (this.parsingStack.isEmpty()) {
            this.hasFinished = true;
        }
        return true;
    }

    JsonValue[] peekValues() {
        return this.values;
    }

    private double getDoubleValue() throws IOException {
        try {
            return this.parser.getDoubleValue();
        }
        catch (IOException ex) {
            if (this.valueReader.hasFallbacksForUnparsableNumbers()) {
                return this.valueReader.defaultDouble();
            }
            throw ex;
        }
    }

    private long getLongValue() throws IOException {
        try {
            return this.parser.getLongValue();
        }
        catch (IOException ex) {
            if (this.valueReader.hasFallbacksForUnparsableNumbers()) {
                return this.valueReader.defaultLong();
            }
            throw ex;
        }
    }

    private JsonValue getScalarValue(JsonToken token) throws IOException {
        switch (token) {
            case VALUE_NULL: {
                return JsonNull.NULL;
            }
            case VALUE_TRUE: {
                return JsonBoolean.TRUE;
            }
            case VALUE_FALSE: {
                return JsonBoolean.FALSE;
            }
            case VALUE_NUMBER_FLOAT: {
                if (this.valueReader.hasLiteralsWithNumbers()) {
                    return JsonDouble.withLiteral((double)this.getDoubleValue(), (String)this.parser.getValueAsString());
                }
                return JsonDouble.of((double)this.getDoubleValue());
            }
            case VALUE_NUMBER_INT: {
                if (this.valueReader.hasLiteralsWithNumbers()) {
                    return JsonLong.withLiteral((long)this.getLongValue(), (String)this.parser.getValueAsString());
                }
                return JsonLong.of((long)this.getLongValue());
            }
            case VALUE_STRING: {
                return JsonString.of((String)this.parser.getText());
            }
        }
        throw new JsonParseException("Unexpected token in JSON: " + token.toString());
    }

    private static class ObjectBuilder
    extends StructureBuilder {
        private final ArrayList<Map.Entry<String, JsonValue>> entries = new ArrayList();

        ObjectBuilder() {
        }

        @Override
        boolean isObject() {
            return true;
        }

        @Override
        ArrayBuilder add(JsonValue value) {
            throw new UnsupportedOperationException();
        }

        @Override
        ObjectBuilder put(String key, JsonValue value) {
            this.entries.add(new AbstractMap.SimpleEntry<String, JsonValue>(key, value));
            return this;
        }

        JsonObject build() {
            return JsonObject.ofEntries((Map.Entry[])ObjectBuilder.toArray(this.entries));
        }

        public String toString() {
            return this.entries.toString();
        }

        private static Map.Entry<String, JsonValue>[] toArray(ArrayList<Map.Entry<String, JsonValue>> entries) {
            return entries.toArray(new Map.Entry[entries.size()]);
        }
    }

    private static class ArrayBuilder
    extends StructureBuilder {
        private final ArrayList<JsonValue> array = new ArrayList();

        ArrayBuilder() {
        }

        @Override
        boolean isArray() {
            return true;
        }

        @Override
        ArrayBuilder add(JsonValue value) {
            this.array.add(value);
            return this;
        }

        @Override
        ArrayBuilder put(String key, JsonValue value) {
            throw new UnsupportedOperationException();
        }

        JsonArray build() {
            return JsonArray.ofList(this.array);
        }

        public String toString() {
            return this.array.toString();
        }
    }

    private static abstract class StructureBuilder {
        private StructureBuilder() {
        }

        boolean isArray() {
            return false;
        }

        boolean isObject() {
            return false;
        }

        abstract StructureBuilder add(JsonValue var1);

        abstract StructureBuilder put(String var1, JsonValue var2);

        abstract JsonValue build();
    }

    private static class ParsingContext {
        private final boolean isObject;
        private String propertyName;
        private int index;

        ParsingContext(boolean isObject) {
            this.isObject = isObject;
            this.propertyName = null;
            this.index = -1;
        }

        boolean isArray() {
            return !this.isObject;
        }

        boolean isObject() {
            return this.isObject;
        }

        void incrementIndex() {
            ++this.index;
        }

        String getIndexInString() {
            return Integer.toString(this.index);
        }

        void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            if (this.isObject) {
                if (this.propertyName == null) {
                    return "null";
                }
                return "\"" + this.propertyName + "\"";
            }
            return Integer.toString(this.index);
        }
    }
}

