/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.retryhelper.jaxrs;

import java.util.Locale;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import org.embulk.util.retryhelper.RetryExecutor;
import org.embulk.util.retryhelper.RetryGiveupException;
import org.embulk.util.retryhelper.Retryable;
import org.embulk.util.retryhelper.jaxrs.JAXRSClientCreator;
import org.embulk.util.retryhelper.jaxrs.JAXRSResponseReader;
import org.embulk.util.retryhelper.jaxrs.JAXRSSingleRequester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAXRSRetryHelper
implements AutoCloseable {
    private final int maximumRetries;
    private final int initialRetryIntervalMillis;
    private final int maximumRetryIntervalMillis;
    private final Client client;
    private final Logger logger;
    private final boolean closeAutomatically;

    public JAXRSRetryHelper(int maximumRetries, int initialRetryIntervalMillis, int maximumRetryIntervalMillis, JAXRSClientCreator clientCreator) {
        this(maximumRetries, initialRetryIntervalMillis, maximumRetryIntervalMillis, clientCreator.create(), true, LoggerFactory.getLogger(JAXRSRetryHelper.class));
    }

    public JAXRSRetryHelper(int maximumRetries, int initialRetryIntervalMillis, int maximumRetryIntervalMillis, JAXRSClientCreator clientCreator, Logger logger) {
        this(maximumRetries, initialRetryIntervalMillis, maximumRetryIntervalMillis, clientCreator.create(), true, logger);
    }

    public static JAXRSRetryHelper createWithReadyMadeClient(int maximumRetries, int initialRetryIntervalMillis, int maximumRetryIntervalMillis, Client client, Logger logger) {
        return new JAXRSRetryHelper(maximumRetries, initialRetryIntervalMillis, maximumRetryIntervalMillis, client, false, logger);
    }

    private JAXRSRetryHelper(int maximumRetries, int initialRetryIntervalMillis, int maximumRetryIntervalMillis, Client client, boolean closeAutomatically, Logger logger) {
        this.maximumRetries = maximumRetries;
        this.initialRetryIntervalMillis = initialRetryIntervalMillis;
        this.maximumRetryIntervalMillis = maximumRetryIntervalMillis;
        this.client = client;
        this.closeAutomatically = closeAutomatically;
        this.logger = logger;
    }

    public <T> T requestWithRetry(final JAXRSResponseReader<T> responseReader, final JAXRSSingleRequester singleRequester) {
        try {
            return (T)RetryExecutor.builder().withRetryLimit(this.maximumRetries).withInitialRetryWaitMillis(this.initialRetryIntervalMillis).withMaxRetryWaitMillis(this.maximumRetryIntervalMillis).build().runInterruptible(new Retryable<T>(){

                public T call() throws Exception {
                    Response response = singleRequester.requestOnce(JAXRSRetryHelper.this.client);
                    if (response.getStatus() / 100 != 2) {
                        throw new WebApplicationException(response);
                    }
                    return responseReader.readResponse(response);
                }

                public boolean isRetryableException(Exception exception) {
                    return singleRequester.toRetry(exception);
                }

                public void onRetry(Exception exception, int retryCount, int retryLimit, int retryWait) throws RetryGiveupException {
                    String message = String.format(Locale.ENGLISH, "Retrying %d/%d after %d seconds. Message: %s", retryCount, retryLimit, retryWait / 1000, exception.getMessage());
                    if (retryCount % 3 == 0) {
                        JAXRSRetryHelper.this.logger.warn(message, (Throwable)exception);
                    } else {
                        JAXRSRetryHelper.this.logger.warn(message);
                    }
                }

                public void onGiveup(Exception first, Exception last) throws RetryGiveupException {
                }
            });
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
        catch (RetryGiveupException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    @Override
    public void close() {
        if (this.closeAutomatically && this.client != null) {
            this.client.close();
        }
    }
}

