/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.retryhelper.jetty92;

import java.util.Locale;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.api.Response;
import org.embulk.util.retryhelper.RetryExecutor;
import org.embulk.util.retryhelper.RetryGiveupException;
import org.embulk.util.retryhelper.Retryable;
import org.embulk.util.retryhelper.jetty92.Jetty92ClientCreator;
import org.embulk.util.retryhelper.jetty92.Jetty92ResponseReader;
import org.embulk.util.retryhelper.jetty92.Jetty92SingleRequester;
import org.embulk.util.retryhelper.jetty92.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty92RetryHelper
implements AutoCloseable {
    private final int maximumRetries;
    private final int initialRetryIntervalMillis;
    private final int maximumRetryIntervalMillis;
    private final HttpClient clientStarted;
    private final Logger logger;
    private final boolean closeAutomatically;

    public Jetty92RetryHelper(int maximumRetries, int initialRetryIntervalMillis, int maximumRetryIntervalMillis, Jetty92ClientCreator clientCreator) {
        this.maximumRetries = maximumRetries;
        this.initialRetryIntervalMillis = initialRetryIntervalMillis;
        this.maximumRetryIntervalMillis = maximumRetryIntervalMillis;
        try {
            this.clientStarted = clientCreator.createAndStart();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.closeAutomatically = true;
        this.logger = LoggerFactory.getLogger(Jetty92RetryHelper.class);
    }

    public Jetty92RetryHelper(int maximumRetries, int initialRetryIntervalMillis, int maximumRetryIntervalMillis, Jetty92ClientCreator clientCreator, Logger logger) {
        this.maximumRetries = maximumRetries;
        this.initialRetryIntervalMillis = initialRetryIntervalMillis;
        this.maximumRetryIntervalMillis = maximumRetryIntervalMillis;
        try {
            this.clientStarted = clientCreator.createAndStart();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.closeAutomatically = true;
        this.logger = logger;
    }

    public static Jetty92RetryHelper createWithReadyMadeClient(int maximumRetries, int initialRetryIntervalMillis, int maximumRetryIntervalMillis, HttpClient clientStarted, Logger logger) {
        return new Jetty92RetryHelper(maximumRetries, initialRetryIntervalMillis, maximumRetryIntervalMillis, clientStarted, false, logger);
    }

    private Jetty92RetryHelper(int maximumRetries, int initialRetryIntervalMillis, int maximumRetryIntervalMillis, HttpClient clientStarted, boolean closeAutomatically, Logger logger) {
        this.maximumRetries = maximumRetries;
        this.initialRetryIntervalMillis = initialRetryIntervalMillis;
        this.maximumRetryIntervalMillis = maximumRetryIntervalMillis;
        this.logger = logger;
        this.clientStarted = clientStarted;
        this.closeAutomatically = closeAutomatically;
    }

    public <T> T requestWithRetry(final Jetty92ResponseReader<T> responseReader, final Jetty92SingleRequester singleRequester) {
        try {
            return (T)RetryExecutor.builder().withRetryLimit(this.maximumRetries).withInitialRetryWaitMillis(this.initialRetryIntervalMillis).withMaxRetryWaitMillis(this.maximumRetryIntervalMillis).build().runInterruptible(new Retryable<T>(){

                public T call() throws Exception {
                    Response.Listener listener = responseReader.getListener();
                    singleRequester.requestOnce(Jetty92RetryHelper.this.clientStarted, listener);
                    Response response = responseReader.getResponse();
                    if (response.getStatus() / 100 != 2) {
                        String errorResponseBody;
                        try {
                            errorResponseBody = responseReader.readResponseContentInString();
                        }
                        catch (Exception ex) {
                            throw new HttpResponseException("Response not 2xx: " + response.getStatus() + " " + response.getReason() + " Response body not available by: " + Util.getStackTraceAsString(ex), response);
                        }
                        throw new HttpResponseException("Response not 2xx: " + response.getStatus() + " " + response.getReason() + " " + errorResponseBody, response);
                    }
                    return responseReader.readResponseContent();
                }

                public boolean isRetryableException(Exception exception) {
                    return singleRequester.toRetry(exception);
                }

                public void onRetry(Exception exception, int retryCount, int retryLimit, int retryWait) throws RetryGiveupException {
                    String message = String.format(Locale.ENGLISH, "Retrying %d/%d after %d seconds. Message: %s", retryCount, retryLimit, retryWait / 1000, exception.getMessage());
                    if (retryCount % 3 == 0) {
                        Jetty92RetryHelper.this.logger.warn(message, (Throwable)exception);
                    } else {
                        Jetty92RetryHelper.this.logger.warn(message);
                    }
                }

                public void onGiveup(Exception first, Exception last) throws RetryGiveupException {
                }
            });
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
        catch (RetryGiveupException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex.getCause());
        }
    }

    @Override
    public void close() {
        if (this.closeAutomatically && this.clientStarted != null) {
            try {
                if (this.clientStarted.isStarted()) {
                    this.clientStarted.stop();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                this.clientStarted.destroy();
            }
        }
    }
}

