/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.retryhelper.jetty92;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

final class Util {
    private Util() {
    }

    static String getStackTraceAsString(Throwable throwable) {
        StringWriter errors = new StringWriter();
        throwable.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    static String asString(InputStream inputStream) throws IOException {
        try {
            return Util.asString(inputStream, StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new UncheckedIOException("Unexpected failure: UTF-8 should be supported.", ex);
        }
    }

    static String asString(InputStream inputStream, Charset charset) throws IOException {
        return Util.asByteArrayOutputStream(inputStream).toString(charset.toString());
    }

    static ByteArrayOutputStream asByteArrayOutputStream(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) >= 0) {
            output.write(buffer, 0, length);
        }
        return output;
    }
}

