/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.rubytime;

import java.time.ZoneOffset;
import java.util.Locale;

public final class RubyTimeZones {
    private static final ZoneOffset OFFSET_N_01 = ZoneOffset.ofHours(-1);
    private static final ZoneOffset OFFSET_N_02 = ZoneOffset.ofHours(-2);
    private static final ZoneOffset OFFSET_N_03 = ZoneOffset.ofHours(-3);
    private static final ZoneOffset OFFSET_N_04 = ZoneOffset.ofHours(-4);
    private static final ZoneOffset OFFSET_N_05 = ZoneOffset.ofHours(-5);
    private static final ZoneOffset OFFSET_N_06 = ZoneOffset.ofHours(-6);
    private static final ZoneOffset OFFSET_N_07 = ZoneOffset.ofHours(-7);
    private static final ZoneOffset OFFSET_N_08 = ZoneOffset.ofHours(-8);
    private static final ZoneOffset OFFSET_N_09 = ZoneOffset.ofHours(-9);
    private static final ZoneOffset OFFSET_N_10 = ZoneOffset.ofHours(-10);
    private static final ZoneOffset OFFSET_N_11 = ZoneOffset.ofHours(-11);
    private static final ZoneOffset OFFSET_N_12 = ZoneOffset.ofHours(-12);
    private static final ZoneOffset OFFSET_P_01 = ZoneOffset.ofHours(1);
    private static final ZoneOffset OFFSET_P_02 = ZoneOffset.ofHours(2);
    private static final ZoneOffset OFFSET_P_03 = ZoneOffset.ofHours(3);
    private static final ZoneOffset OFFSET_P_04 = ZoneOffset.ofHours(4);
    private static final ZoneOffset OFFSET_P_05 = ZoneOffset.ofHours(5);
    private static final ZoneOffset OFFSET_P_06 = ZoneOffset.ofHours(6);
    private static final ZoneOffset OFFSET_P_07 = ZoneOffset.ofHours(7);
    private static final ZoneOffset OFFSET_P_08 = ZoneOffset.ofHours(8);
    private static final ZoneOffset OFFSET_P_09 = ZoneOffset.ofHours(9);
    private static final ZoneOffset OFFSET_P_10 = ZoneOffset.ofHours(10);
    private static final ZoneOffset OFFSET_P_11 = ZoneOffset.ofHours(11);
    private static final ZoneOffset OFFSET_P_12 = ZoneOffset.ofHours(12);

    private RubyTimeZones() {
    }

    public static ZoneOffset toZoneOffset(String zoneName, ZoneOffset defaultZoneOffset) {
        if (zoneName == null || zoneName.isEmpty()) {
            return defaultZoneOffset;
        }
        if (zoneName.charAt(0) == '+' || zoneName.charAt(0) == '-') {
            if (RubyTimeZones.matchesOffsetRepresentation(zoneName)) {
                return ZoneOffset.of(zoneName);
            }
            return defaultZoneOffset;
        }
        ZoneOffset zoneOffset = RubyTimeZones.mapZoneNametoZoneOffset(zoneName.toUpperCase(Locale.ENGLISH));
        if (zoneOffset != null) {
            return zoneOffset;
        }
        return defaultZoneOffset;
    }

    private static boolean matchesOffsetRepresentation(String zone) {
        switch (zone.length()) {
            case 3: {
                return Character.isDigit(zone.charAt(1)) && Character.isDigit(zone.charAt(2));
            }
            case 5: {
                return Character.isDigit(zone.charAt(1)) && Character.isDigit(zone.charAt(2)) && Character.isDigit(zone.charAt(3)) && Character.isDigit(zone.charAt(4));
            }
            case 6: {
                return Character.isDigit(zone.charAt(1)) && Character.isDigit(zone.charAt(2)) && zone.charAt(3) == ':' && Character.isDigit(zone.charAt(4)) && Character.isDigit(zone.charAt(5));
            }
            case 7: {
                return Character.isDigit(zone.charAt(1)) && Character.isDigit(zone.charAt(2)) && Character.isDigit(zone.charAt(3)) && Character.isDigit(zone.charAt(4)) && Character.isDigit(zone.charAt(5)) && Character.isDigit(zone.charAt(6));
            }
            case 9: {
                return Character.isDigit(zone.charAt(1)) && Character.isDigit(zone.charAt(2)) && zone.charAt(3) == ':' && Character.isDigit(zone.charAt(4)) && Character.isDigit(zone.charAt(5)) && zone.charAt(6) == ':' && Character.isDigit(zone.charAt(7)) && Character.isDigit(zone.charAt(8));
            }
        }
        return false;
    }

    private static int extractOffsetRepresentation(String zone) {
        switch (zone.length()) {
            case 3: {
                if (Character.isDigit(zone.charAt(1)) && Character.isDigit(zone.charAt(2))) {
                    return (Character.digit(zone.charAt(1), 10) * 10 + Character.digit(zone.charAt(2), 10)) * 3600;
                }
                return Integer.MIN_VALUE;
            }
            case 5: {
                if (Character.isDigit(zone.charAt(1)) && Character.isDigit(zone.charAt(2)) && Character.isDigit(zone.charAt(3)) && Character.isDigit(zone.charAt(4))) {
                    return (Character.digit(zone.charAt(1), 10) * 10 + Character.digit(zone.charAt(2), 10)) * 3600 + (Character.digit(zone.charAt(3), 10) * 10 + Character.digit(zone.charAt(4), 10)) * 60;
                }
                return Integer.MIN_VALUE;
            }
            case 6: {
                if (Character.isDigit(zone.charAt(1)) && Character.isDigit(zone.charAt(2)) && zone.charAt(3) == ':' && Character.isDigit(zone.charAt(4)) && Character.isDigit(zone.charAt(5))) {
                    return (Character.digit(zone.charAt(1), 10) * 10 + Character.digit(zone.charAt(2), 10)) * 3600 + (Character.digit(zone.charAt(4), 10) * 10 + Character.digit(zone.charAt(5), 10)) * 60;
                }
                return Integer.MIN_VALUE;
            }
            case 7: {
                if (Character.isDigit(zone.charAt(1)) && Character.isDigit(zone.charAt(2)) && Character.isDigit(zone.charAt(3)) && Character.isDigit(zone.charAt(4)) && Character.isDigit(zone.charAt(5)) && Character.isDigit(zone.charAt(6))) {
                    return (Character.digit(zone.charAt(1), 10) * 10 + Character.digit(zone.charAt(2), 10)) * 3600 + (Character.digit(zone.charAt(3), 10) * 10 + Character.digit(zone.charAt(4), 10)) * 60 + (Character.digit(zone.charAt(5), 10) * 10 + Character.digit(zone.charAt(6), 10));
                }
                return Integer.MIN_VALUE;
            }
            case 9: {
                if (Character.isDigit(zone.charAt(1)) && Character.isDigit(zone.charAt(2)) && zone.charAt(3) == ':' && Character.isDigit(zone.charAt(4)) && Character.isDigit(zone.charAt(5)) && zone.charAt(6) == ':' && Character.isDigit(zone.charAt(7)) && Character.isDigit(zone.charAt(8))) {
                    return (Character.digit(zone.charAt(1), 10) * 10 + Character.digit(zone.charAt(2), 10)) * 3600 + (Character.digit(zone.charAt(4), 10) * 10 + Character.digit(zone.charAt(5), 10)) * 60 + (Character.digit(zone.charAt(7), 10) * 10 + Character.digit(zone.charAt(8), 10));
                }
                return Integer.MIN_VALUE;
            }
        }
        return Integer.MIN_VALUE;
    }

    private static ZoneOffset mapZoneNametoZoneOffset(String name) {
        switch (name) {
            case "UTC": {
                return ZoneOffset.UTC;
            }
            case "Z": {
                return ZoneOffset.UTC;
            }
            case "UT": {
                return ZoneOffset.UTC;
            }
            case "GMT": {
                return ZoneOffset.UTC;
            }
            case "EST": {
                return OFFSET_N_05;
            }
            case "EDT": {
                return OFFSET_N_04;
            }
            case "CST": {
                return OFFSET_N_06;
            }
            case "CDT": {
                return OFFSET_N_05;
            }
            case "MST": {
                return OFFSET_N_07;
            }
            case "MDT": {
                return OFFSET_N_06;
            }
            case "PST": {
                return OFFSET_N_08;
            }
            case "PDT": {
                return OFFSET_N_07;
            }
            case "A": {
                return OFFSET_P_01;
            }
            case "B": {
                return OFFSET_P_02;
            }
            case "C": {
                return OFFSET_P_03;
            }
            case "D": {
                return OFFSET_P_04;
            }
            case "E": {
                return OFFSET_P_05;
            }
            case "F": {
                return OFFSET_P_06;
            }
            case "G": {
                return OFFSET_P_07;
            }
            case "H": {
                return OFFSET_P_08;
            }
            case "I": {
                return OFFSET_P_09;
            }
            case "K": {
                return OFFSET_P_10;
            }
            case "L": {
                return OFFSET_P_11;
            }
            case "M": {
                return OFFSET_P_12;
            }
            case "N": {
                return OFFSET_N_01;
            }
            case "O": {
                return OFFSET_N_02;
            }
            case "P": {
                return OFFSET_N_03;
            }
            case "Q": {
                return OFFSET_N_04;
            }
            case "R": {
                return OFFSET_N_05;
            }
            case "S": {
                return OFFSET_N_06;
            }
            case "T": {
                return OFFSET_N_07;
            }
            case "U": {
                return OFFSET_N_08;
            }
            case "V": {
                return OFFSET_N_09;
            }
            case "W": {
                return OFFSET_N_10;
            }
            case "X": {
                return OFFSET_N_11;
            }
            case "Y": {
                return OFFSET_N_12;
            }
        }
        return null;
    }
}

