/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.rubytime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

enum FormatDirective {
    YEAR_WITH_CENTURY(true, 'Y'),
    CENTURY(true, 'C'),
    YEAR_WITHOUT_CENTURY(true, 'y'),
    MONTH_OF_YEAR(true, 'm'),
    MONTH_OF_YEAR_FULL_NAME(false, 'B'),
    MONTH_OF_YEAR_ABBREVIATED_NAME(false, 'b'),
    MONTH_OF_YEAR_ABBREVIATED_NAME_ALIAS_SMALL_H(false, 'h'),
    DAY_OF_MONTH_ZERO_PADDED(true, 'd'),
    DAY_OF_MONTH_BLANK_PADDED(true, 'e'),
    DAY_OF_YEAR(true, 'j'),
    HOUR_OF_DAY_ZERO_PADDED(true, 'H'),
    HOUR_OF_DAY_BLANK_PADDED(true, 'k'),
    HOUR_OF_AMPM_ZERO_PADDED(true, 'I'),
    HOUR_OF_AMPM_BLANK_PADDED(true, 'l'),
    AMPM_OF_DAY_LOWER_CASE(false, 'P'),
    AMPM_OF_DAY_UPPER_CASE(false, 'p'),
    MINUTE_OF_HOUR(true, 'M'),
    SECOND_OF_MINUTE(true, 'S'),
    MILLI_OF_SECOND(true, 'L'),
    NANO_OF_SECOND(true, 'N'),
    TIME_OFFSET(false, 'z'),
    TIME_ZONE_NAME(false, 'Z'),
    DAY_OF_WEEK_FULL_NAME(false, 'A'),
    DAY_OF_WEEK_ABBREVIATED_NAME(false, 'a'),
    DAY_OF_WEEK_STARTING_WITH_MONDAY_1(true, 'u'),
    DAY_OF_WEEK_STARTING_WITH_SUNDAY_0(true, 'w'),
    WEEK_BASED_YEAR_WITH_CENTURY(true, 'G'),
    WEEK_BASED_YEAR_WITHOUT_CENTURY(true, 'g'),
    WEEK_OF_WEEK_BASED_YEAR(true, 'V'),
    WEEK_OF_YEAR_STARTING_WITH_SUNDAY(true, 'U'),
    WEEK_OF_YEAR_STARTING_WITH_MONDAY(true, 'W'),
    SECONDS_SINCE_EPOCH(true, 's'),
    MILLISECONDS_SINCE_EPOCH(false, 'Q'),
    IMMEDIATE_PERCENT(false, '%'),
    IMMEDIATE_NEWLINE(false, 'n'),
    IMMEDIATE_TAB(false, 't'),
    RECURRED_LOWER_C('c'),
    RECURRED_UPPER_D('D'),
    RECURRED_LOWER_X('x'),
    RECURRED_UPPER_F('F'),
    RECURRED_UPPER_R('R'),
    RECURRED_LOWER_R('r'),
    RECURRED_UPPER_T('T'),
    RECURRED_UPPER_X('X'),
    RECURRED_LOWER_V('v'),
    RECURRED_PLUS('+');

    private static final Map<Character, FormatDirective> FROM_CONVERSION_SPECIFIER;
    private final char conversionSpecifier;
    private final boolean isNumeric;

    private FormatDirective(boolean isNumeric, char conversionSpecifier) {
        this.conversionSpecifier = conversionSpecifier;
        this.isNumeric = isNumeric;
    }

    private FormatDirective(char conversionSpecifier) {
        this.conversionSpecifier = conversionSpecifier;
        this.isNumeric = false;
    }

    static FormatDirective of(char conversionSpecifier) {
        return FROM_CONVERSION_SPECIFIER.get(Character.valueOf(conversionSpecifier));
    }

    public String toString() {
        return "" + this.conversionSpecifier;
    }

    char getSpecifier() {
        return this.conversionSpecifier;
    }

    boolean isNumeric() {
        return this.isNumeric;
    }

    static {
        HashMap<Character, FormatDirective> charDirectiveMapBuilt = new HashMap<Character, FormatDirective>();
        for (FormatDirective directive : FormatDirective.values()) {
            if (directive.conversionSpecifier == '\u0000') continue;
            charDirectiveMapBuilt.put(Character.valueOf(directive.conversionSpecifier), directive);
        }
        FROM_CONVERSION_SPECIFIER = Collections.unmodifiableMap(charDirectiveMapBuilt);
    }
}

