/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.rubytime;

import java.util.Objects;

final class FormatDirectiveOptions {
    static final FormatDirectiveOptions EMPTY = new FormatDirectiveOptions(false, 0, false, false, false, '\u0000', 0);
    private boolean onlyForFormatter;
    private final int precision;
    private final boolean isLeft;
    private final boolean isUpper;
    private final boolean isChCase;
    private final char padding;
    private final int colons;

    private FormatDirectiveOptions(boolean onlyForFormatter, int precision, boolean isLeft, boolean isUpper, boolean isChCase, char padding, int colons) {
        this.onlyForFormatter = onlyForFormatter;
        this.precision = precision;
        this.isLeft = isLeft;
        this.isUpper = isUpper;
        this.isChCase = isChCase;
        this.padding = padding;
        this.colons = colons;
    }

    static Builder builder() {
        return new Builder();
    }

    boolean onlyForFormatter() {
        return this.onlyForFormatter;
    }

    int getPrecision(int defaultPrecision) {
        if (this.precision <= 0) {
            return defaultPrecision;
        }
        return this.precision;
    }

    boolean isLeft() {
        return this.isLeft;
    }

    boolean isUpper() {
        return this.isUpper;
    }

    boolean isChCase() {
        return this.isChCase;
    }

    char getPadding(char defaultPadding) {
        if (this.padding == '\u0000') {
            return defaultPadding;
        }
        return this.padding;
    }

    int getColons() {
        return this.colons;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof FormatDirectiveOptions)) {
            return false;
        }
        FormatDirectiveOptions other = (FormatDirectiveOptions)otherObject;
        return Objects.equals(this.onlyForFormatter, other.onlyForFormatter) && Objects.equals(this.precision, other.precision) && Objects.equals(this.isLeft, other.isLeft) && Objects.equals(this.isUpper, other.isUpper) && Objects.equals(this.isChCase, other.isChCase) && Objects.equals(Character.valueOf(this.padding), Character.valueOf(other.padding)) && Objects.equals(this.colons, other.colons);
    }

    public int hashCode() {
        return Objects.hash(this.onlyForFormatter, this.precision, this.isLeft, this.isUpper, this.isChCase, Character.valueOf(this.padding), this.colons);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isLeft) {
            builder.append('-');
        }
        if (this.isUpper) {
            builder.append('^');
        }
        if (this.isChCase) {
            builder.append('#');
        }
        if (this.padding != '\u0000') {
            builder.append(this.padding);
        }
        if (this.colons > 0) {
            for (int i = 0; i < this.colons; ++i) {
                builder.append(':');
            }
        }
        if (this.precision > 0) {
            builder.append(String.valueOf(this.precision));
        }
        return builder.toString();
    }

    static class Builder {
        private boolean onlyForFormatter = false;
        private int precision = 0;
        private boolean isLeft = false;
        private boolean isUpper = false;
        private boolean isChCase = false;
        private char padding = '\u0000';
        private int colons = 0;

        Builder() {
        }

        Builder setColons(int colons) {
            if (colons <= 0) {
                throw new IllegalArgumentException();
            }
            if (this.colons > 0) {
                throw new IllegalArgumentException();
            }
            if (colons > 3) {
                this.onlyForFormatter = true;
            }
            this.colons = colons;
            return this;
        }

        Builder setPadding(char padding) {
            this.onlyForFormatter = true;
            this.padding = padding;
            return this;
        }

        Builder setLeft() {
            this.onlyForFormatter = true;
            this.isLeft = true;
            return this;
        }

        Builder setUpper() {
            this.onlyForFormatter = true;
            this.isUpper = true;
            return this;
        }

        Builder setChCase() {
            this.onlyForFormatter = true;
            this.isChCase = true;
            return this;
        }

        Builder setPrecision(int precision) {
            this.onlyForFormatter = true;
            this.precision = precision;
            return this;
        }

        boolean isPrecisionSpecified() {
            return this.precision > 0;
        }

        FormatDirectiveOptions build() {
            return new FormatDirectiveOptions(this.onlyForFormatter, this.precision, this.isLeft, this.isUpper, this.isChCase, this.padding, this.colons);
        }
    }
}

