/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.rubytime;

import java.time.temporal.TemporalAccessor;
import org.embulk.util.rubytime.Format;
import org.embulk.util.rubytime.FormatterWithContext;
import org.embulk.util.rubytime.ParserWithContext;
import org.embulk.util.rubytime.RubyDateTimeParseException;
import org.embulk.util.rubytime.RubyDateTimeResolver;

public final class RubyDateTimeFormatter {
    private final Format format;
    private final RubyDateTimeResolver resolver;

    private RubyDateTimeFormatter(Format format, RubyDateTimeResolver resolver) {
        this.format = format;
        this.resolver = resolver;
    }

    public static RubyDateTimeFormatter ofPattern(String pattern) {
        return new RubyDateTimeFormatter(Format.compile(pattern), RubyDateTimeResolver.ofDefault());
    }

    public String format(TemporalAccessor temporal) {
        return new FormatterWithContext(temporal).format(this.format);
    }

    public String formatWithZoneNameStyle(TemporalAccessor temporal, ZoneNameStyle zoneNameStyle) {
        return new FormatterWithContext(temporal).format(this.format, zoneNameStyle);
    }

    public TemporalAccessor parseUnresolved(String text) {
        return new ParserWithContext(text).parse(this.format);
    }

    public TemporalAccessor parse(String text) {
        try {
            return this.resolver.resolve(this.parseUnresolved(text));
        }
        catch (RubyDateTimeParseException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new RubyDateTimeParseException("Text '" + text + "' could not be parsed: " + ex.getMessage(), text, 0, ex);
        }
    }

    public RubyDateTimeFormatter withResolver(RubyDateTimeResolver resolver) {
        return new RubyDateTimeFormatter(this.format, resolver);
    }

    public static enum ZoneNameStyle {
        NONE,
        SHORT;

    }
}

