/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.rubytime;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.ValueRange;
import org.embulk.util.rubytime.RubyChronoFields;
import org.embulk.util.rubytime.RubyDateTimeResolver;
import org.embulk.util.rubytime.RubyTemporalQueries;
import org.embulk.util.rubytime.RubyTemporalQueryResolver;
import org.embulk.util.rubytime.RubyTimeZones;

final class DefaultRubyTimeResolver
extends RubyDateTimeResolver {
    private static final int[] leapYearMonthDays = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] commonYearMonthDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private final boolean acceptsEmpty;
    private final ZoneOffset defaultOffset;
    private final int defaultYear;
    private final int defaultMonthOfYear;
    private final int defaultDayOfMonth;
    private final int defaultHourOfDay;
    private final int defaultMinuteOfHour;
    private final int defaultSecondOfMinute;
    private final int defaultNanoOfSecond;

    DefaultRubyTimeResolver(boolean acceptsEmpty, ZoneOffset defaultOffset, int defaultYear, int defaultMonthOfYear, int defaultDayOfMonth, int defaultHourOfDay, int defaultMinuteOfHour, int defaultSecondOfMinute, int defaultNanoOfSecond) {
        this.acceptsEmpty = acceptsEmpty;
        this.defaultOffset = defaultOffset;
        this.defaultYear = defaultYear;
        this.defaultMonthOfYear = defaultMonthOfYear;
        this.defaultDayOfMonth = defaultDayOfMonth;
        this.defaultHourOfDay = defaultHourOfDay;
        this.defaultMinuteOfHour = defaultMinuteOfHour;
        this.defaultSecondOfMinute = defaultSecondOfMinute;
        this.defaultNanoOfSecond = defaultNanoOfSecond;
    }

    @Override
    public TemporalAccessor resolve(TemporalAccessor original) {
        String zone = original.query(RubyTemporalQueries.zone());
        ZoneOffset offset = RubyTimeZones.toZoneOffset(zone, this.defaultOffset);
        if (offset == null) {
            if (zone == null) {
                throw new DateTimeException("Empty time zone ID.");
            }
            throw new DateTimeException("Invalid time zone ID: '" + zone);
        }
        if (original.isSupported(ChronoField.INSTANT_SECONDS) || original.isSupported(RubyChronoFields.INSTANT_MILLIS)) {
            Instant instant;
            if (original.isSupported(RubyChronoFields.INSTANT_MILLIS)) {
                long instantMillis = original.getLong(RubyChronoFields.INSTANT_MILLIS);
                instant = Instant.ofEpochMilli(instantMillis);
            } else {
                long instantSeconds = original.getLong(ChronoField.INSTANT_SECONDS);
                instant = Instant.ofEpochSecond(instantSeconds);
            }
            if (original.isSupported(ChronoField.NANO_OF_SECOND)) {
                int nanoOfSecond = original.get(ChronoField.NANO_OF_SECOND);
                if (!instant.isBefore(Instant.EPOCH)) {
                    return new ResolvedFromInstant(original, instant.plusNanos(nanoOfSecond));
                }
                return new ResolvedFromInstant(original, instant.minusNanos(nanoOfSecond));
            }
            return new ResolvedFromInstant(original, instant);
        }
        return new ResolvedFromOffsetDateTime(original, this.getOffsetAppliedDateTime(original, offset));
    }

    private OffsetDateTime getOffsetAppliedDateTime(TemporalAccessor original, ZoneOffset zoneOffset) {
        Boolean parsedLeapSecond = original.query(DateTimeFormatter.parsedLeapSecond());
        Period parsedExcessDays = original.query(DateTimeFormatter.parsedExcessDays());
        if (!(this.acceptsEmpty || original.isSupported(ChronoField.YEAR) || original.isSupported(ChronoField.MONTH_OF_YEAR) || original.isSupported(ChronoField.DAY_OF_MONTH) || original.isSupported(ChronoField.HOUR_OF_DAY) || original.isSupported(ChronoField.MINUTE_OF_HOUR) || original.isSupported(ChronoField.SECOND_OF_MINUTE) || original.isSupported(ChronoField.NANO_OF_SECOND))) {
            throw new DateTimeException("No time information.");
        }
        int year = original.isSupported(ChronoField.YEAR) ? original.get(ChronoField.YEAR) : this.defaultYear;
        int monthOfYear = original.isSupported(ChronoField.MONTH_OF_YEAR) ? original.get(ChronoField.MONTH_OF_YEAR) : this.defaultMonthOfYear;
        int dayOfMonth = original.isSupported(ChronoField.DAY_OF_MONTH) ? original.get(ChronoField.DAY_OF_MONTH) : this.defaultDayOfMonth;
        int hourOfDay = original.isSupported(ChronoField.HOUR_OF_DAY) ? original.get(ChronoField.HOUR_OF_DAY) : this.defaultHourOfDay;
        int minuteOfHour = original.isSupported(ChronoField.MINUTE_OF_HOUR) ? original.get(ChronoField.MINUTE_OF_HOUR) : this.defaultMinuteOfHour;
        int secondOfMinute = original.isSupported(ChronoField.SECOND_OF_MINUTE) ? original.get(ChronoField.SECOND_OF_MINUTE) : this.defaultSecondOfMinute;
        int nanoOfSecond = original.isSupported(ChronoField.NANO_OF_SECOND) ? original.get(ChronoField.NANO_OF_SECOND) : this.defaultNanoOfSecond;
        int offset = zoneOffset.getTotalSeconds();
        if (parsedLeapSecond != null && parsedLeapSecond.booleanValue()) {
            secondOfMinute = 59;
            --offset;
        }
        if (parsedExcessDays != null) {
            if (parsedExcessDays.getDays() == 1 && parsedExcessDays.getMonths() == 0 && parsedExcessDays.getYears() == 0) {
                offset -= 86400;
                hourOfDay = 0;
            } else if (!parsedExcessDays.isZero()) {
                throw new DateTimeException("Hour is not in the range of 0-24.");
            }
        }
        if (offset < 0) {
            offset = -offset;
            int offsetSecond = Math.floorMod(offset, 60);
            offset = Math.floorDiv(offset, 60);
            if (offsetSecond != 0) {
                offset += Math.floorDiv(secondOfMinute += offsetSecond, 60);
                secondOfMinute = Math.floorMod(secondOfMinute, 60);
            }
            int offsetMinute = Math.floorMod(offset, 60);
            offset = Math.floorDiv(offset, 60);
            if (offsetMinute != 0) {
                offset += Math.floorDiv(minuteOfHour += offsetMinute, 60);
                minuteOfHour = Math.floorMod(minuteOfHour, 60);
            }
            int offsetHour = Math.floorMod(offset, 24);
            offset = Math.floorDiv(offset, 24);
            if (offsetHour != 0) {
                offset += Math.floorDiv(hourOfDay += offsetHour, 24);
                hourOfDay = Math.floorMod(hourOfDay, 24);
            }
            if (offset != 0) {
                int days = DefaultRubyTimeResolver.monthDays(year, monthOfYear);
                if (monthOfYear == 2 && days == 28 && dayOfMonth == 29) {
                    throw new DateTimeException("Invalid date 'February 29' as '" + year + "' is not a leap year");
                }
                if (days < (dayOfMonth += offset)) {
                    if (12 < ++monthOfYear) {
                        monthOfYear = 1;
                        ++year;
                    }
                    dayOfMonth = 1;
                }
            }
        } else if (0 < offset) {
            int offsetSecond = Math.floorMod(offset, 60);
            offset = Math.floorDiv(offset, 60);
            if (offsetSecond != 0) {
                offset -= Math.floorDiv(secondOfMinute -= offsetSecond, 60);
                secondOfMinute = Math.floorMod(secondOfMinute, 60);
            }
            int offsetMinute = Math.floorMod(offset, 60);
            offset = Math.floorDiv(offset, 60);
            if (offsetMinute != 0) {
                offset -= Math.floorDiv(minuteOfHour -= offsetMinute, 60);
                minuteOfHour = Math.floorMod(minuteOfHour, 60);
            }
            int offsetHour = Math.floorMod(offset, 24);
            offset = Math.floorDiv(offset, 24);
            if (offsetHour != 0) {
                offset -= Math.floorDiv(hourOfDay -= offsetHour, 24);
                hourOfDay = Math.floorMod(hourOfDay, 24);
            }
            if (offset != 0 && (dayOfMonth -= offset) < 1) {
                if (--monthOfYear < 1) {
                    --year;
                    monthOfYear = 12;
                }
                dayOfMonth = DefaultRubyTimeResolver.monthDays(year, monthOfYear);
            }
        }
        return OffsetDateTime.of(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond, ZoneOffset.UTC);
    }

    private int getWithDefaultOrThrow(TemporalAccessor original, TemporalField field, int defaultValue) {
        if (original.isSupported(field)) {
            return original.get(field);
        }
        if (this.acceptsEmpty) {
            return defaultValue;
        }
        throw new DateTimeException("No time information enough.");
    }

    private static int monthDays(int year, int monthOfYear) {
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            return leapYearMonthDays[monthOfYear - 1];
        }
        return commonYearMonthDays[monthOfYear - 1];
    }

    private class ResolvedFromInstant
    implements TemporalAccessor,
    RubyTemporalQueryResolver {
        private final TemporalAccessor original;
        private final Instant resolvedInstant;
        private final OffsetDateTime resolvedDateTime;

        private ResolvedFromInstant(TemporalAccessor original, Instant resolvedInstant) {
            this.original = original;
            this.resolvedInstant = resolvedInstant;
            this.resolvedDateTime = OffsetDateTime.ofInstant(resolvedInstant, ZoneOffset.UTC);
        }

        @Override
        public long getLong(TemporalField field) {
            if (this.resolvedInstant.isSupported(field)) {
                return this.resolvedInstant.getLong(field);
            }
            if (this.original.isSupported(field)) {
                return this.original.getLong(field);
            }
            return this.resolvedDateTime.getLong(field);
        }

        @Override
        public boolean isSupported(TemporalField field) {
            if (this.resolvedInstant.isSupported(field)) {
                return true;
            }
            if (this.original.isSupported(field)) {
                return true;
            }
            return this.resolvedDateTime.isSupported(field);
        }

        @Override
        public <R> R query(TemporalQuery<R> query) {
            R resultOriginal;
            if (RubyTemporalQueries.isSpecificQuery(query) && (resultOriginal = this.original.query(query)) != null) {
                return resultOriginal;
            }
            R resultFromResolvedInstant = this.resolvedInstant.query(query);
            if (resultFromResolvedInstant != null) {
                return resultFromResolvedInstant;
            }
            R resultOriginal2 = this.original.query(query);
            if (resultOriginal2 != null) {
                return resultOriginal2;
            }
            return this.resolvedDateTime.query(query);
        }

        @Override
        public ValueRange range(TemporalField field) {
            if (this.resolvedInstant.isSupported(field)) {
                return this.resolvedInstant.range(field);
            }
            if (this.original.isSupported(field)) {
                return this.original.range(field);
            }
            return this.resolvedDateTime.range(field);
        }

        @Override
        public String getOriginalText() {
            if (this.original instanceof RubyTemporalQueryResolver) {
                RubyTemporalQueryResolver resolver = (RubyTemporalQueryResolver)((Object)this.original);
                return resolver.getOriginalText();
            }
            return null;
        }

        @Override
        public String getZone() {
            if (this.original instanceof RubyTemporalQueryResolver) {
                RubyTemporalQueryResolver resolver = (RubyTemporalQueryResolver)((Object)this.original);
                return resolver.getZone();
            }
            return null;
        }

        @Override
        public String getLeftover() {
            if (this.original instanceof RubyTemporalQueryResolver) {
                RubyTemporalQueryResolver resolver = (RubyTemporalQueryResolver)((Object)this.original);
                return resolver.getLeftover();
            }
            return null;
        }
    }

    private class ResolvedFromOffsetDateTime
    implements TemporalAccessor,
    RubyTemporalQueryResolver {
        private final TemporalAccessor original;
        private final OffsetDateTime resolvedDateTime;

        private ResolvedFromOffsetDateTime(TemporalAccessor original, OffsetDateTime resolvedDateTime) {
            this.original = original;
            this.resolvedDateTime = resolvedDateTime;
        }

        @Override
        public long getLong(TemporalField field) {
            if (this.original.isSupported(field)) {
                return this.original.getLong(field);
            }
            return this.resolvedDateTime.getLong(field);
        }

        @Override
        public boolean isSupported(TemporalField field) {
            if (this.original.isSupported(field)) {
                return true;
            }
            return this.resolvedDateTime.isSupported(field);
        }

        @Override
        public <R> R query(TemporalQuery<R> query) {
            R resultOriginal = this.original.query(query);
            if (resultOriginal != null) {
                return resultOriginal;
            }
            return this.resolvedDateTime.query(query);
        }

        @Override
        public ValueRange range(TemporalField field) {
            if (this.original.isSupported(field)) {
                return this.original.range(field);
            }
            return this.resolvedDateTime.range(field);
        }

        @Override
        public String getOriginalText() {
            if (this.original instanceof RubyTemporalQueryResolver) {
                RubyTemporalQueryResolver resolver = (RubyTemporalQueryResolver)((Object)this.original);
                return resolver.getOriginalText();
            }
            return null;
        }

        @Override
        public String getZone() {
            if (this.original instanceof RubyTemporalQueryResolver) {
                RubyTemporalQueryResolver resolver = (RubyTemporalQueryResolver)((Object)this.original);
                return resolver.getZone();
            }
            return null;
        }

        @Override
        public String getLeftover() {
            if (this.original instanceof RubyTemporalQueryResolver) {
                RubyTemporalQueryResolver resolver = (RubyTemporalQueryResolver)((Object)this.original);
                return resolver.getLeftover();
            }
            return null;
        }
    }
}

